/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Queue;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxPublishOn;
import reactor.core.publisher.ParallelFlux;
import reactor.core.scheduler.Scheduler;

final class ParallelRunOn<T>
extends ParallelFlux<T>
implements Scannable,
Fuseable {
    final ParallelFlux<? extends T> source;
    final Scheduler scheduler;
    final int prefetch;
    final Supplier<Queue<T>> queueSupplier;

    ParallelRunOn(ParallelFlux<? extends T> parent, Scheduler scheduler, int prefetch, Supplier<Queue<T>> queueSupplier) {
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.source = parent;
        this.scheduler = scheduler;
        this.prefetch = prefetch;
        this.queueSupplier = queueSupplier;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.source;
            }
            case PREFETCH: {
                return this.getPrefetch();
            }
        }
        return null;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            FluxPublishOn.PublishOnSubscriber<? super T> parent;
            Subscriber<? super T> a = subscribers[i];
            Scheduler.Worker w = this.scheduler.createWorker();
            parents[i] = parent = new FluxPublishOn.PublishOnSubscriber<T>(a, this.scheduler, w, true, this.prefetch, this.queueSupplier);
        }
        this.source.subscribe(parents);
    }

    @Override
    public long getPrefetch() {
        return this.prefetch;
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }
}

