/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.Disposable;
import reactor.core.scheduler.DisposableContainer;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.OpenHashSet;

final class ExecutorServiceScheduler
implements Scheduler {
    static final Runnable EMPTY = () -> {};
    static final Future<?> CANCELLED = new FutureTask<Object>(EMPTY, null);
    static final Future<?> FINISHED = new FutureTask<Object>(EMPTY, null);
    final ExecutorService executor;
    final boolean interruptOnCancel;

    ExecutorServiceScheduler(ExecutorService executorService, boolean interruptOnCancel) {
        this.executor = executorService instanceof ScheduledExecutorService ? Schedulers.decorateScheduledExecutorService("ExecutorService", () -> (ScheduledExecutorService)executorService) : Schedulers.decorateExecutorService("ExecutorService", () -> executorService);
        this.interruptOnCancel = interruptOnCancel;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ExecutorServiceWorker(this.executor, this.interruptOnCancel);
    }

    boolean isTimeCapable() {
        return this.executor instanceof ScheduledExecutorService;
    }

    @Override
    public Disposable schedule(Runnable task) {
        try {
            return new DisposableFuture(this.executor.submit(task), this.interruptOnCancel);
        }
        catch (RejectedExecutionException ree) {
            return REJECTED;
        }
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        if (!this.isTimeCapable()) {
            return REJECTED;
        }
        ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)this.executor;
        try {
            return new DisposableFuture(scheduledExecutor.schedule(task, delay, unit), this.interruptOnCancel);
        }
        catch (RejectedExecutionException ree) {
            return REJECTED;
        }
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (!this.isTimeCapable()) {
            return REJECTED;
        }
        ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)this.executor;
        try {
            return new DisposableFuture(scheduledExecutor.scheduleAtFixedRate(task, initialDelay, period, unit), this.interruptOnCancel);
        }
        catch (RejectedExecutionException ree) {
            return REJECTED;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.executor.isShutdown();
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    @Override
    public void dispose() {
        Schedulers.executorServiceShutdown(this.executor, "ExecutorService");
    }

    static final class ExecutorServiceSchedulerRunnable
    implements Runnable,
    Disposable {
        static final ExecutorServiceWorker DISPOSED_PARENT = new ExecutorServiceWorker(null, false);
        static final ExecutorServiceWorker DONE_PARENT = new ExecutorServiceWorker(null, false);
        final Runnable task;
        volatile Future<?> future;
        static final AtomicReferenceFieldUpdater<ExecutorServiceSchedulerRunnable, Future> FUTURE = AtomicReferenceFieldUpdater.newUpdater(ExecutorServiceSchedulerRunnable.class, Future.class, "future");
        volatile ExecutorServiceWorker parent;
        static final AtomicReferenceFieldUpdater<ExecutorServiceSchedulerRunnable, ExecutorServiceWorker> PARENT = AtomicReferenceFieldUpdater.newUpdater(ExecutorServiceSchedulerRunnable.class, ExecutorServiceWorker.class, "parent");

        ExecutorServiceSchedulerRunnable(Runnable task, ExecutorServiceWorker parent) {
            this.task = task;
            PARENT.lazySet(this, parent);
        }

        @Override
        public void run() {
            try {
                try {
                    this.task.run();
                }
                catch (Throwable ex) {
                    Schedulers.handleError(ex);
                }
            }
            finally {
                Future<?> f;
                ExecutorServiceWorker o = this.parent;
                if (o != DISPOSED_PARENT && o != null && PARENT.compareAndSet(this, o, DONE_PARENT)) {
                    o.remove(this);
                }
                while ((f = this.future) != CANCELLED && !FUTURE.compareAndSet(this, f, FINISHED)) {
                }
            }
        }

        void setFuture(Future<?> f) {
            Future<?> o;
            do {
                if ((o = this.future) == FINISHED) {
                    return;
                }
                if (o != CANCELLED) continue;
                f.cancel(this.parent.interruptOnCancel);
                return;
            } while (!FUTURE.compareAndSet(this, o, f));
        }

        @Override
        public boolean isDisposed() {
            Future<?> a = this.future;
            return FINISHED == a || CANCELLED == a;
        }

        @Override
        public void dispose() {
            ExecutorServiceWorker o;
            Future<?> f;
            while ((f = this.future) != FINISHED && f != CANCELLED) {
                if (!FUTURE.compareAndSet(this, f, CANCELLED)) continue;
                if (f == null) break;
                f.cancel(this.parent.interruptOnCancel);
                break;
            }
            do {
                if ((o = this.parent) != DONE_PARENT && o != DISPOSED_PARENT && o != null) continue;
                return;
            } while (!PARENT.compareAndSet(this, o, DISPOSED_PARENT));
            o.remove(this);
        }
    }

    static final class ExecutorServiceWorker
    implements Scheduler.Worker,
    DisposableContainer<ExecutorServiceSchedulerRunnable> {
        final ExecutorService executor;
        final boolean interruptOnCancel;
        volatile boolean terminated;
        OpenHashSet<ExecutorServiceSchedulerRunnable> tasks;

        ExecutorServiceWorker(ExecutorService executor, boolean interruptOnCancel) {
            this.executor = executor;
            this.interruptOnCancel = interruptOnCancel;
            this.tasks = new OpenHashSet();
        }

        boolean isTimeCapable() {
            return this.executor instanceof ScheduledExecutorService;
        }

        @Override
        public Disposable schedule(Runnable t) {
            ExecutorServiceSchedulerRunnable sr = new ExecutorServiceSchedulerRunnable(t, this);
            try {
                if (this.add(sr)) {
                    Future<?> f = this.executor.submit(sr);
                    sr.setFuture(f);
                    return sr;
                }
            }
            catch (RejectedExecutionException ree) {
                this.removeAndDispose(sr);
            }
            return Scheduler.REJECTED;
        }

        @Override
        public Disposable schedule(Runnable t, long delay, TimeUnit unit) {
            if (!this.isTimeCapable()) {
                return Scheduler.REJECTED;
            }
            ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)this.executor;
            ExecutorServiceSchedulerRunnable sr = new ExecutorServiceSchedulerRunnable(t, this);
            try {
                if (this.add(sr)) {
                    ScheduledFuture<?> f = scheduledExecutor.schedule(sr, delay, unit);
                    sr.setFuture(f);
                    return sr;
                }
            }
            catch (RejectedExecutionException ree) {
                this.removeAndDispose(sr);
            }
            return Scheduler.REJECTED;
        }

        @Override
        public Disposable schedulePeriodically(Runnable t, long initialDelay, long period, TimeUnit unit) {
            if (!this.isTimeCapable()) {
                return Scheduler.REJECTED;
            }
            ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)this.executor;
            ExecutorServiceSchedulerRunnable sr = new ExecutorServiceSchedulerRunnable(t, this);
            try {
                if (this.add(sr)) {
                    ScheduledFuture<?> f = scheduledExecutor.scheduleAtFixedRate(sr, initialDelay, period, unit);
                    sr.setFuture(f);
                    return sr;
                }
            }
            catch (RejectedExecutionException ree) {
                this.removeAndDispose(sr);
            }
            return Scheduler.REJECTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(ExecutorServiceSchedulerRunnable sr) {
            if (!this.terminated) {
                ExecutorServiceWorker executorServiceWorker = this;
                synchronized (executorServiceWorker) {
                    if (!this.terminated) {
                        this.tasks.add(sr);
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(ExecutorServiceSchedulerRunnable sr) {
            if (!this.terminated) {
                ExecutorServiceWorker executorServiceWorker = this;
                synchronized (executorServiceWorker) {
                    if (!this.terminated) {
                        this.tasks.remove(sr);
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void shutdown() {
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            if (!this.terminated) {
                OpenHashSet<ExecutorServiceSchedulerRunnable> coll;
                ExecutorServiceWorker executorServiceWorker = this;
                synchronized (executorServiceWorker) {
                    if (this.terminated) {
                        return;
                    }
                    coll = this.tasks;
                    this.tasks = null;
                    this.terminated = true;
                }
                if (!coll.isEmpty()) {
                    Object[] a;
                    for (Object o : a = coll.keys()) {
                        if (o == null) continue;
                        ((ExecutorServiceSchedulerRunnable)o).dispose();
                    }
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.terminated;
        }
    }

    static final class DisposableFuture
    implements Disposable {
        final Future<?> f;
        final boolean interruptOnCancel;

        DisposableFuture(Future<?> f, boolean interruptOnCancel) {
            this.f = f;
            this.interruptOnCancel = interruptOnCancel;
        }

        @Override
        public void dispose() {
            this.f.cancel(this.interruptOnCancel);
        }

        @Override
        public boolean isDisposed() {
            return this.f.isCancelled() || this.f.isDone();
        }
    }
}

