/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class DynamicErrorInfo
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "dynamic-error-info");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public boolean hasSideEffects() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new DynamicErrorInfoCall();
    }

    private static class DynamicErrorInfoCall
    extends ExtensionFunctionCall {
        private DynamicErrorInfoCall() {
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String var = arguments[0].head().getStringValue();
            XPathException error = context.getCurrentException();
            if (error == null) {
                return EmptySequence.getInstance();
            }
            Location locator = error.getLocator();
            if (var.equals("code")) {
                StructuredQName errorCodeQName = error.getErrorCodeQName();
                if (errorCodeQName == null) {
                    return EmptySequence.getInstance();
                }
                return new QNameValue(errorCodeQName, BuiltInAtomicType.QNAME);
            }
            if (var.equals("description")) {
                return new StringValue(error.getMessage());
            }
            if (var.equals("value")) {
                Sequence value = error.getErrorObject();
                if (value == null) {
                    return EmptySequence.getInstance();
                }
                return value;
            }
            if (var.equals("module")) {
                String module;
                String string = module = locator == null ? null : locator.getSystemId();
                if (module == null) {
                    return EmptySequence.getInstance();
                }
                return new StringValue(module);
            }
            if (var.equals("line-number")) {
                int line;
                int n = line = locator == null ? -1 : locator.getLineNumber();
                if (line == -1) {
                    return EmptySequence.getInstance();
                }
                return new Int64Value(line);
            }
            if (var.equals("column-number")) {
                int column;
                int n = column = locator == null ? -1 : locator.getColumnNumber();
                if (column == -1) {
                    return EmptySequence.getInstance();
                }
                return new Int64Value(column);
            }
            return EmptySequence.getInstance();
        }
    }
}

