/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config.artifact;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.artifact.ArtifactProperties;
import org.mule.runtime.api.util.Preconditions;

public class DefaultArtifactProperties
implements ArtifactProperties {
    private final Map<Object, Object> configProperties;
    private final Map<Object, Object> springProperties;
    private final Map<Object, Object> systemProperties;
    private final Map<Object, Object> artifactProperties;
    private final Map<String, String> environmentProperties;
    private final Map<Object, Object> mergeProperties;

    public DefaultArtifactProperties(Map<Object, Object> configProperties, Map<Object, Object> springProperties, Map<Object, Object> artifactProperties) {
        Preconditions.checkArgument((configProperties != null ? 1 : 0) != 0, (String)"configProperties cannot be null");
        Preconditions.checkArgument((springProperties != null ? 1 : 0) != 0, (String)"springProperties cannot be null");
        Preconditions.checkArgument((artifactProperties != null ? 1 : 0) != 0, (String)"artifactProperties cannot be null");
        this.configProperties = configProperties;
        this.artifactProperties = artifactProperties;
        this.springProperties = springProperties;
        this.systemProperties = Collections.unmodifiableMap(System.getProperties());
        this.environmentProperties = Collections.unmodifiableMap(System.getenv());
        HashMap<Object, Object> mergeProperties = new HashMap<Object, Object>();
        mergeProperties.putAll(this.configProperties);
        mergeProperties.putAll(this.springProperties);
        mergeProperties.putAll(this.artifactProperties);
        mergeProperties.putAll(this.environmentProperties);
        mergeProperties.putAll(this.systemProperties);
        this.mergeProperties = Collections.unmodifiableMap(mergeProperties);
    }

    public <T, K> T getProperty(K key) {
        return (T)this.mergeProperties.get(key);
    }

    public Set<Object> getPropertyNames() {
        return this.mergeProperties.keySet();
    }

    public Map<Object, Object> toImmutableMap() {
        return this.mergeProperties;
    }
}

