/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.core.internal.streaming.object.Position;

public class Bucket<T> {
    private final List<T> items;
    private final int capacity;
    private final int index;

    public Bucket(int index, int capacity) {
        this.index = index;
        this.capacity = capacity;
        this.items = new ArrayList<T>(capacity);
    }

    public Optional<T> get(int index) {
        if (index < this.items.size()) {
            return Optional.ofNullable(this.items.get(index));
        }
        return Optional.empty();
    }

    public boolean contains(Position position) {
        return this.index == position.getBucketIndex() && position.getItemIndex() < this.items.size();
    }

    public int getIndex() {
        return this.index;
    }

    public boolean add(T item) {
        if (this.items.size() < this.capacity) {
            this.items.add(item);
            return true;
        }
        return false;
    }
}

