/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class ByteArrayToHexString
extends AbstractTransformer {
    private volatile boolean upperCase = false;

    public ByteArrayToHexString() {
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.setReturnDataType(DataType.STRING);
    }

    public boolean getUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean value) {
        this.upperCase = value;
    }

    @Override
    protected Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src == null) {
            return "";
        }
        try {
            byte[] bytes = null;
            bytes = src instanceof CursorStreamProvider ? this.handleStream((InputStream)((CursorStreamProvider)src).openCursor()) : (src instanceof InputStream ? this.handleStream((InputStream)src) : (byte[])src);
            return StringUtils.toHexString(bytes, this.upperCase);
        }
        catch (Exception ex) {
            throw new TransformerException(this, (Throwable)ex);
        }
    }

    private byte[] handleStream(InputStream input) {
        try {
            byte[] byArray = IOUtils.toByteArray(input);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }
}

