/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.accept.MediaTypeFileExtensionResolver;
import org.springframework.web.context.request.NativeWebRequest;

public class ContentNegotiationManager
implements ContentNegotiationStrategy,
MediaTypeFileExtensionResolver {
    private static final List<MediaType> MEDIA_TYPE_ALL = Arrays.asList(MediaType.ALL);
    private final List<ContentNegotiationStrategy> contentNegotiationStrategies = new ArrayList<ContentNegotiationStrategy>();
    private final Set<MediaTypeFileExtensionResolver> fileExtensionResolvers = new LinkedHashSet<MediaTypeFileExtensionResolver>();

    public ContentNegotiationManager(ContentNegotiationStrategy ... strategies) {
        Assert.notEmpty((Object[])strategies, (String)"At least one ContentNegotiationStrategy is expected");
        this.contentNegotiationStrategies.addAll(Arrays.asList(strategies));
        for (ContentNegotiationStrategy strategy : this.contentNegotiationStrategies) {
            if (!(strategy instanceof MediaTypeFileExtensionResolver)) continue;
            this.fileExtensionResolvers.add((MediaTypeFileExtensionResolver)((Object)strategy));
        }
    }

    public ContentNegotiationManager(Collection<ContentNegotiationStrategy> strategies) {
        Assert.notEmpty(strategies, (String)"At least one ContentNegotiationStrategy is expected");
        this.contentNegotiationStrategies.addAll(strategies);
        for (ContentNegotiationStrategy strategy : this.contentNegotiationStrategies) {
            if (!(strategy instanceof MediaTypeFileExtensionResolver)) continue;
            this.fileExtensionResolvers.add((MediaTypeFileExtensionResolver)((Object)strategy));
        }
    }

    public ContentNegotiationManager() {
        this(new HeaderContentNegotiationStrategy());
    }

    public List<ContentNegotiationStrategy> getStrategies() {
        return this.contentNegotiationStrategies;
    }

    public void addFileExtensionResolvers(MediaTypeFileExtensionResolver ... resolvers) {
        this.fileExtensionResolvers.addAll(Arrays.asList(resolvers));
    }

    @Override
    public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) throws HttpMediaTypeNotAcceptableException {
        for (ContentNegotiationStrategy strategy : this.contentNegotiationStrategies) {
            List<MediaType> mediaTypes = strategy.resolveMediaTypes(webRequest);
            if (mediaTypes.isEmpty() || mediaTypes.equals(MEDIA_TYPE_ALL)) continue;
            return mediaTypes;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> resolveFileExtensions(MediaType mediaType) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (MediaTypeFileExtensionResolver resolver : this.fileExtensionResolvers) {
            result.addAll(resolver.resolveFileExtensions(mediaType));
        }
        return new ArrayList<String>(result);
    }

    @Override
    public List<String> getAllFileExtensions() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (MediaTypeFileExtensionResolver resolver : this.fileExtensionResolvers) {
            result.addAll(resolver.getAllFileExtensions());
        }
        return new ArrayList<String>(result);
    }
}

