/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class RegistryLookupValueResolver<T>
implements ValueResolver<T> {
    private final String key;
    @Inject
    private MuleContext muleContext;

    public RegistryLookupValueResolver(String key) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)key) ? 1 : 0) != 0, (String)"key cannot be null or blank");
        this.key = key;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        Object value = this.muleContext.getRegistry().get(this.key);
        if (value == null) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Element '%s' is not defined in the Mule Registry", this.key)));
        }
        return (T)value;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

