/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class EndsWith
extends CollatingFunctionFixed {
    public static boolean endsWith(StringValue arg0, StringValue arg1, StringCollator collator) throws XPathException {
        if (arg1 == null || arg1.isZeroLength() || collator.comparesEqual(arg1.getPrimitiveStringValue(), "")) {
            return true;
        }
        if (arg0 == null || arg0.isZeroLength()) {
            return false;
        }
        String s0 = arg0.getStringValue();
        String s1 = arg1.getStringValue();
        if (collator instanceof CodepointCollator) {
            return s0.endsWith(s1);
        }
        if (collator instanceof SimpleCollation) {
            collator = ((SimpleCollation)collator).getSubstringMatcher();
        }
        if (collator instanceof SubstringMatcher) {
            return ((SubstringMatcher)collator).endsWith(s0, s1);
        }
        throw new XPathException("The collation requested for ends-with() does not support substring matching", "FOCH0004");
    }

    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue s0 = (StringValue)arguments[0].head();
        StringValue s1 = (StringValue)arguments[1].head();
        return BooleanValue.get(EndsWith.endsWith(s0, s1, this.getStringCollator()));
    }
}

