/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxAwaitOnSubscribe<T>
extends FluxSource<T, T> {
    FluxAwaitOnSubscribe(Flux<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new PostOnSubscribeSubscriber<T>(s));
    }

    static final class PostOnSubscribeSubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<PostOnSubscribeSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(PostOnSubscribeSubscriber.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<PostOnSubscribeSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(PostOnSubscribeSubscriber.class, "requested");

        PostOnSubscribeSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                long r;
                this.actual.onSubscribe((Subscription)this);
                if (Operators.setOnce(S, this, s) && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                    s.request(r);
                }
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public void request(long n) {
            Subscription a = this.s;
            if (a != null) {
                a.request(n);
            } else if (Operators.validate(n)) {
                long r;
                Operators.getAndAddCap(REQUESTED, this, n);
                a = this.s;
                if (a != null && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                    a.request(n);
                }
            }
        }

        public void cancel() {
            Operators.terminate(S, this);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
            }
            return InnerOperator.super.scan(key);
        }
    }
}

