/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

final class FluxWindowBoundary<T, U>
extends FluxSource<T, Flux<T>> {
    final Publisher<U> other;
    final Supplier<? extends Queue<T>> processorQueueSupplier;
    final Supplier<? extends Queue<Object>> drainQueueSupplier;

    FluxWindowBoundary(Flux<? extends T> source, Publisher<U> other, Supplier<? extends Queue<T>> processorQueueSupplier, Supplier<? extends Queue<Object>> drainQueueSupplier) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
        this.drainQueueSupplier = Objects.requireNonNull(drainQueueSupplier, "drainQueueSupplier");
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super Flux<T>> s) {
        WindowBoundaryMain main = new WindowBoundaryMain(s, this.processorQueueSupplier, this.processorQueueSupplier.get(), this.drainQueueSupplier.get());
        s.onSubscribe(main);
        if (main.emit(main.window)) {
            this.other.subscribe(main.boundary);
            this.source.subscribe(main);
        }
    }

    static final class WindowBoundaryOther<U>
    extends Operators.DeferredSubscription
    implements InnerConsumer<U> {
        final WindowBoundaryMain<?, U> main;

        WindowBoundaryOther(WindowBoundaryMain<?, U> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public Object scan(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.main;
            }
            return super.scan(key);
        }

        public void onNext(U t) {
            this.main.boundaryNext();
        }

        public void onError(Throwable t) {
            this.main.boundaryError(t);
        }

        public void onComplete() {
            this.main.boundaryComplete();
        }
    }

    static final class WindowBoundaryMain<T, U>
    implements InnerOperator<T, Flux<T>>,
    Disposable {
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        final WindowBoundaryOther<U> boundary;
        final Queue<Object> queue;
        final Subscriber<? super Flux<T>> actual;
        UnicastProcessor<T> window;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<WindowBoundaryMain, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(WindowBoundaryMain.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<WindowBoundaryMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowBoundaryMain.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowBoundaryMain> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowBoundaryMain.class, "wip");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<WindowBoundaryMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(WindowBoundaryMain.class, Throwable.class, "error");
        volatile int open;
        static final AtomicIntegerFieldUpdater<WindowBoundaryMain> OPEN = AtomicIntegerFieldUpdater.newUpdater(WindowBoundaryMain.class, "open");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowBoundaryMain> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowBoundaryMain.class, "once");
        static final Object BOUNDARY_MARKER = new Object();
        static final Object DONE = new Object();

        @Override
        public final Subscriber<? super Flux<T>> actual() {
            return this.actual;
        }

        WindowBoundaryMain(Subscriber<? super Flux<T>> actual, Supplier<? extends Queue<T>> processorQueueSupplier, Queue<T> processorQueue, Queue<Object> queue) {
            this.actual = actual;
            this.processorQueueSupplier = processorQueueSupplier;
            this.window = new UnicastProcessor<T>(processorQueue, this);
            this.open = 2;
            this.boundary = new WindowBoundaryOther(this);
            this.queue = queue;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case ERROR: {
                    return this.error;
                }
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
                case PREFETCH: {
                    return Integer.MAX_VALUE;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case BUFFERED: {
                    return this.queue.size();
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.boundary, this.window);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            WindowBoundaryMain windowBoundaryMain = this;
            synchronized (windowBoundaryMain) {
                this.queue.offer(t);
            }
            this.drain();
        }

        public void onError(Throwable t) {
            this.boundary.cancel();
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            this.boundary.cancel();
            WindowBoundaryMain windowBoundaryMain = this;
            synchronized (windowBoundaryMain) {
                this.queue.offer(DONE);
            }
            this.drain();
        }

        @Override
        public void dispose() {
            if (OPEN.decrementAndGet(this) == 0) {
                this.cancelMain();
                this.boundary.cancel();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.s == Operators.cancelledSubscription();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        void cancelMain() {
            Operators.terminate(S, this);
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void boundaryNext() {
            WindowBoundaryMain windowBoundaryMain = this;
            synchronized (windowBoundaryMain) {
                this.queue.offer(BOUNDARY_MARKER);
            }
            if (this.once != 0) {
                this.boundary.cancel();
            }
            this.drain();
        }

        void boundaryError(Throwable e) {
            this.cancelMain();
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void boundaryComplete() {
            this.cancelMain();
            WindowBoundaryMain windowBoundaryMain = this;
            synchronized (windowBoundaryMain) {
                this.queue.offer(DONE);
            }
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            Subscriber<? super Flux<T>> a = this.actual;
            Queue<Object> q = this.queue;
            UnicastProcessor<Object> w = this.window;
            int missed = 1;
            while (true) {
                if (this.error != null) {
                    q.clear();
                    Throwable e = Exceptions.terminate(ERROR, this);
                    if (e != Exceptions.TERMINATED) {
                        w.onError(e);
                        a.onError(e);
                    }
                    return;
                }
                Object o = q.poll();
                if (o != null) {
                    if (o == DONE) {
                        q.clear();
                        w.onComplete();
                        a.onComplete();
                        return;
                    }
                    if (o != BOUNDARY_MARKER) {
                        Object v = o;
                        w.onNext(v);
                    }
                    if (o != BOUNDARY_MARKER) continue;
                    w.onComplete();
                    if (this.once != 0) continue;
                    if (this.requested != 0L) {
                        Queue<T> pq = this.processorQueueSupplier.get();
                        OPEN.getAndIncrement(this);
                        w = new UnicastProcessor<T>(pq, this);
                        this.window = w;
                        a.onNext(w);
                        if (this.requested == Long.MAX_VALUE) continue;
                        REQUESTED.decrementAndGet(this);
                        continue;
                    }
                    q.clear();
                    this.cancelMain();
                    this.boundary.cancel();
                    a.onError((Throwable)Exceptions.failWithOverflow("Could not create new window due to lack of requests"));
                    return;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        boolean emit(UnicastProcessor<T> w) {
            long r = this.requested;
            if (r != 0L) {
                this.actual.onNext(w);
                if (r != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
                return true;
            }
            this.cancel();
            this.actual.onError((Throwable)Exceptions.failWithOverflow("Could not emit buffer due to lack of requests"));
            return false;
        }
    }
}

