/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoCallable<T>
extends Mono<T>
implements Callable<T>,
Fuseable {
    final Callable<? extends T> callable;

    MonoCallable(Callable<? extends T> callable) {
        this.callable = Objects.requireNonNull(callable, "callable");
    }

    public void subscribe(Subscriber<? super T> s) {
        T t;
        Operators.MonoSubscriber sds = new Operators.MonoSubscriber(s);
        s.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        try {
            t = Objects.requireNonNull(this.callable.call(), "callable returned null");
        }
        catch (Throwable e) {
            s.onError(Operators.onOperatorError(e));
            return;
        }
        sds.complete(t);
    }

    @Override
    public T block() {
        return this.block(Duration.ZERO);
    }

    @Override
    public T block(Duration m) {
        try {
            return Objects.requireNonNull(this.callable.call(), "The callable source returned null");
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw Exceptions.propagate(e);
        }
    }

    @Override
    public T call() throws Exception {
        return Objects.requireNonNull(this.callable.call(), "The callable source returned null");
    }
}

