/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoRunnable
extends Mono<Void>
implements Callable<Void> {
    final Runnable run;

    MonoRunnable(Runnable run) {
        this.run = Objects.requireNonNull(run, "run");
    }

    public void subscribe(Subscriber<? super Void> s) {
        try {
            this.run.run();
        }
        catch (Throwable ex) {
            Operators.error(s, Operators.onOperatorError(ex));
            return;
        }
        Operators.complete(s);
    }

    @Override
    public Void block(Duration m) {
        this.run.run();
        return null;
    }

    @Override
    public Void block() {
        this.run.run();
        return null;
    }

    @Override
    public Void call() throws Exception {
        this.run.run();
        return null;
    }
}

