/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.EventLoopProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.core.publisher.RingBuffer;
import reactor.util.concurrent.QueueSupplier;
import reactor.util.concurrent.WaitStrategy;

public final class TopicProcessor<E>
extends EventLoopProcessor<E> {
    final RingBuffer.Reader barrier;
    final RingBuffer.Sequence minimum;
    final ExecutorService requestTaskExecutor;

    public static <E> TopicProcessor<E> create() {
        return TopicProcessor.create(TopicProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> TopicProcessor<E> create(String name) {
        return TopicProcessor.create(name, QueueSupplier.SMALL_BUFFER_SIZE, true);
    }

    public static <E> TopicProcessor<E> create(boolean autoCancel) {
        return TopicProcessor.create(TopicProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service) {
        return TopicProcessor.create(service, QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, boolean autoCancel) {
        return TopicProcessor.create(service, QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize) {
        return TopicProcessor.create(name, bufferSize, null, true);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize, boolean autoCancel) {
        return TopicProcessor.create(name, bufferSize, null, autoCancel);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, int bufferSize) {
        return TopicProcessor.create(service, bufferSize, WaitStrategy.liteBlocking(), true);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, int bufferSize, boolean autoCancel) {
        return TopicProcessor.create(service, bufferSize, WaitStrategy.liteBlocking(), autoCancel);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize, WaitStrategy strategy) {
        return TopicProcessor.create(name, bufferSize, strategy, null);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize, WaitStrategy strategy, Supplier<E> signalSupplier) {
        return new TopicProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, false, true, signalSupplier);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, false, autoCancel, null);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, int bufferSize, WaitStrategy strategy) {
        return TopicProcessor.create(service, bufferSize, strategy, true);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(null, service, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, false, autoCancel, null);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, ExecutorService requestTaskExecutor, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(null, service, requestTaskExecutor, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, false, autoCancel, null);
    }

    public static <E> TopicProcessor<E> share(boolean autoCancel) {
        return TopicProcessor.share(TopicProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service) {
        return TopicProcessor.share(service, QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, boolean autoCancel) {
        return TopicProcessor.share(service, QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize) {
        return TopicProcessor.share(name, bufferSize, null, true);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, boolean autoCancel) {
        return TopicProcessor.share(name, bufferSize, null, autoCancel);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, int bufferSize) {
        return TopicProcessor.share(service, bufferSize, null, true);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, int bufferSize, boolean autoCancel) {
        return TopicProcessor.share(service, bufferSize, null, autoCancel);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, WaitStrategy strategy) {
        return TopicProcessor.share(name, bufferSize, strategy, null);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, Supplier<E> signalSupplier) {
        return TopicProcessor.share(name, bufferSize, null, signalSupplier);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, WaitStrategy waitStrategy, Supplier<E> signalSupplier) {
        return new TopicProcessor<E>(name, bufferSize, waitStrategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : waitStrategy, true, true, signalSupplier);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, true, autoCancel, null);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, int bufferSize, WaitStrategy strategy) {
        return TopicProcessor.share(service, bufferSize, strategy, true);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(null, service, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, true, autoCancel, null);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, ExecutorService requestTaskExecutor, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(null, service, requestTaskExecutor, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, true, autoCancel, null);
    }

    TopicProcessor(String name, int bufferSize, WaitStrategy waitStrategy, boolean shared, boolean autoCancel, Supplier<E> signalSupplier) {
        this(new EventLoopProcessor.EventLoopFactory(name, autoCancel), null, bufferSize, waitStrategy, shared, autoCancel, signalSupplier);
    }

    TopicProcessor(ThreadFactory threadFactory, ExecutorService executor, int bufferSize, WaitStrategy waitStrategy, boolean shared, boolean autoCancel, Supplier<E> signalSupplier) {
        this(threadFactory, executor, TopicProcessor.defaultRequestTaskExecutor(TopicProcessor.defaultName(threadFactory, TopicProcessor.class)), bufferSize, waitStrategy, shared, autoCancel, signalSupplier);
    }

    TopicProcessor(ThreadFactory threadFactory, ExecutorService executor, ExecutorService requestTaskExecutor, int bufferSize, WaitStrategy waitStrategy, boolean shared, boolean autoCancel, Supplier<E> signalSupplier) {
        super(bufferSize, threadFactory, executor, autoCancel, shared, () -> {
            EventLoopProcessor.Slot signal = new EventLoopProcessor.Slot();
            if (signalSupplier != null) {
                signal.value = signalSupplier.get();
            }
            return signal;
        }, waitStrategy);
        Objects.requireNonNull(requestTaskExecutor, "requestTaskExecutor");
        this.minimum = RingBuffer.newSequence(-1L);
        this.barrier = this.ringBuffer.newReader();
        this.requestTaskExecutor = requestTaskExecutor;
    }

    @Override
    public void subscribe(Subscriber<? super E> subscriber) {
        if (subscriber == null) {
            throw Exceptions.argumentIsNullException();
        }
        if (!this.alive()) {
            TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.minimum).subscribe(subscriber);
            return;
        }
        RingBuffer.Sequence pendingRequest = RingBuffer.newSequence(0L);
        TopicInner<? super E> signalProcessor = new TopicInner<E>(this, pendingRequest, subscriber);
        if (this.incrementSubscribers()) {
            signalProcessor.sequence.set(this.minimum.getAsLong());
            this.ringBuffer.addGatingSequence(signalProcessor.sequence);
        } else {
            signalProcessor.sequence.set(this.ringBuffer.getCursor());
            this.ringBuffer.addGatingSequence(signalProcessor.sequence);
        }
        try {
            this.executor.execute(signalProcessor);
        }
        catch (Throwable t) {
            this.ringBuffer.removeGatingSequence(signalProcessor.sequence);
            this.decrementSubscribers();
            if (!this.alive() && RejectedExecutionException.class.isAssignableFrom(t.getClass())) {
                TopicProcessor.coldSource(this.ringBuffer, t, this.error, this.minimum).subscribe(subscriber);
            }
            Operators.error(subscriber, t);
        }
    }

    @Override
    public Flux<E> drain() {
        return TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.minimum);
    }

    @Override
    protected void doError(Throwable t) {
        this.barrier.signal();
    }

    @Override
    protected void doComplete() {
        this.barrier.signal();
    }

    @Override
    public long getPending() {
        return this.ringBuffer.getPending();
    }

    @Override
    protected void requestTask(Subscription s) {
        this.minimum.set(this.ringBuffer.getCursor());
        this.ringBuffer.addGatingSequence(this.minimum);
        this.requestTaskExecutor.execute(EventLoopProcessor.createRequestTask(s, () -> {
            if (!this.alive()) {
                WaitStrategy.alert();
            }
        }, this.minimum::set, () -> SUBSCRIBER_COUNT.get(this) == 0 ? this.minimum.getAsLong() : this.ringBuffer.getMinimumGatingSequence(this.minimum), this.readWait, this, this.ringBuffer.bufferSize()));
    }

    @Override
    public void run() {
        if (!this.alive() && SUBSCRIBER_COUNT.get(this) == 0) {
            WaitStrategy.alert();
        }
    }

    @Override
    protected void specificShutdown() {
        this.requestTaskExecutor.shutdown();
    }

    static final class TopicInner<T>
    implements Runnable,
    InnerProducer<T> {
        final AtomicBoolean running = new AtomicBoolean(true);
        final RingBuffer.Sequence sequence = RingBuffer.newSequence(-1L);
        final TopicProcessor<T> processor;
        final RingBuffer.Sequence pendingRequest;
        final Subscriber<? super T> subscriber;
        final Runnable waiter = new Runnable(){

            @Override
            public void run() {
                if (!running.get() || processor.isTerminated()) {
                    WaitStrategy.alert();
                }
            }
        };

        TopicInner(TopicProcessor<T> processor, RingBuffer.Sequence pendingRequest, Subscriber<? super T> subscriber) {
            this.processor = processor;
            this.pendingRequest = pendingRequest;
            this.subscriber = subscriber;
        }

        void halt() {
            this.running.set(false);
            this.processor.barrier.alert();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.currentThread().setContextClassLoader(this.processor.contextClassLoader);
                this.subscriber.onSubscribe((Subscription)this);
                if (!EventLoopProcessor.waitRequestOrTerminalEvent(this.pendingRequest, this.processor.barrier, this.running, this.sequence, this.waiter)) {
                    if (!this.running.get()) {
                        return;
                    }
                    if (this.processor.terminated == 1) {
                        if (this.processor.ringBuffer.getAsLong() == -1L) {
                            if (this.processor.error != null) {
                                this.subscriber.onError(this.processor.error);
                                return;
                            }
                            this.subscriber.onComplete();
                            return;
                        }
                    } else if (this.processor.terminated == 2) {
                        return;
                    }
                }
                long nextSequence = this.sequence.getAsLong() + 1L;
                boolean unbounded = this.pendingRequest.getAsLong() == Long.MAX_VALUE;
                while (true) {
                    try {
                        while (true) {
                            long availableSequence = this.processor.barrier.waitFor(nextSequence, this.waiter);
                            while (nextSequence <= availableSequence) {
                                EventLoopProcessor.Slot event = (EventLoopProcessor.Slot)this.processor.ringBuffer.get(nextSequence);
                                while (!unbounded && EventLoopProcessor.getAndSub(this.pendingRequest, 1L) == 0L) {
                                    if (!this.running.get() || this.processor.isTerminated()) {
                                        WaitStrategy.alert();
                                    }
                                    LockSupport.parkNanos(1L);
                                }
                                this.subscriber.onNext(event.value);
                                ++nextSequence;
                            }
                            this.sequence.set(availableSequence);
                            if (Operators.emptySubscription() == this.processor.upstreamSubscription) continue;
                            this.processor.readWait.signalAllWhenBlocking();
                        }
                    }
                    catch (Throwable ex) {
                        block26: {
                            block25: {
                                block30: {
                                    block27: {
                                        block29: {
                                            block28: {
                                                if (!WaitStrategy.isAlert(ex) && !Exceptions.isCancel(ex)) break block25;
                                                if (!this.running.get()) break block26;
                                                if (this.processor.terminated != 1) break block27;
                                                if (this.processor.error == null) break block28;
                                                this.subscriber.onError(this.processor.error);
                                                break block26;
                                            }
                                            if (nextSequence <= this.processor.ringBuffer.getAsLong()) break block29;
                                            this.subscriber.onComplete();
                                            break block26;
                                        }
                                        LockSupport.parkNanos(1L);
                                        break block30;
                                    }
                                    if (this.processor.terminated == 2) break block26;
                                }
                                this.processor.barrier.clearAlert();
                                continue;
                                break block26;
                            }
                            throw Exceptions.propagate(ex);
                        }
                        this.processor.ringBuffer.removeGatingSequence(this.sequence);
                        this.processor.decrementSubscribers();
                        this.running.set(false);
                        this.processor.readWait.signalAllWhenBlocking();
                    }
                    break;
                }
            }
            finally {
                this.processor.ringBuffer.removeGatingSequence(this.sequence);
                this.processor.decrementSubscribers();
                this.running.set(false);
                this.processor.readWait.signalAllWhenBlocking();
            }
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.processor;
                }
                case PREFETCH: {
                    return Integer.MAX_VALUE;
                }
                case TERMINATED: {
                    return this.processor.isTerminated();
                }
                case CANCELLED: {
                    return !this.running.get();
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.pendingRequest.getAsLong();
                }
                case BUFFERED: {
                    return this.processor.ringBuffer.getCursor() - this.sequence.getAsLong();
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.subscriber;
        }

        public void request(long n) {
            if (Operators.checkRequest(n, this.subscriber)) {
                if (!this.running.get()) {
                    return;
                }
                EventLoopProcessor.addCap(this.pendingRequest, n);
            }
        }

        public void cancel() {
            this.halt();
        }
    }
}

