/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.interception;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.message.ErrorBuilder;

public class DefaultInterceptionEvent
implements InterceptionEvent {
    public static final String INTERCEPTION_RESOLVED_PARAMS = "core:interceptionResolvedParams";
    public static final String INTERCEPTION_RESOLVED_CONTEXT = "core:interceptionResolvedContext";
    private Event interceptedInput;
    private Event.Builder interceptedOutput;

    public DefaultInterceptionEvent(Event interceptedInput) {
        this.interceptedInput = interceptedInput;
        this.interceptedOutput = Event.builder(interceptedInput);
    }

    public Message getMessage() {
        return this.interceptedInput.getMessage();
    }

    public <T> TypedValue<T> getVariable(String key) {
        return this.interceptedInput.getVariable(key);
    }

    public Set<String> getVariableNames() {
        return this.interceptedInput.getVariableNames();
    }

    public Optional<Error> getError() {
        return this.interceptedInput.getError();
    }

    public EventContext getContext() {
        return this.interceptedInput.getContext();
    }

    public DefaultInterceptionEvent message(Message message) {
        this.interceptedOutput = this.interceptedOutput.message(message);
        return this;
    }

    public DefaultInterceptionEvent variables(Map<String, Object> variables) {
        this.interceptedOutput = this.interceptedOutput.variables(variables);
        return this;
    }

    public DefaultInterceptionEvent addVariable(String key, Object value) {
        this.interceptedOutput = this.interceptedOutput.addVariable(key, value);
        return this;
    }

    public DefaultInterceptionEvent addVariable(String key, Object value, DataType mediaType) {
        this.interceptedOutput = this.interceptedOutput.addVariable(key, value, mediaType);
        return this;
    }

    public DefaultInterceptionEvent removeVariable(String key) {
        this.interceptedOutput = this.interceptedOutput.removeVariable(key);
        return this;
    }

    public DefaultInterceptionEvent setError(ErrorType errorType, Throwable cause) {
        ErrorBuilder errorBuilder = ErrorBuilder.builder(cause);
        errorBuilder.errorType(errorType);
        this.interceptedOutput = this.interceptedOutput.error(errorBuilder.build());
        return this;
    }

    public Event resolve() {
        Event newEvent = this.interceptedOutput.build();
        if (this.interceptedInput != newEvent) {
            this.interceptedInput = newEvent;
            this.interceptedOutput = Event.builder(this.interceptedInput).removeParameter(INTERCEPTION_RESOLVED_PARAMS);
        }
        return this.interceptedInput;
    }

    public Event getInterceptionResult() {
        return this.interceptedInput;
    }
}

