/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.el.context.AbstractMapContext;

public class FlowVariableMapContext
extends AbstractMapContext<Object> {
    private Event event;
    private Event.Builder eventBuider;

    public FlowVariableMapContext(Event event, Event.Builder eventBuider) {
        this.event = event;
        this.eventBuider = eventBuider;
    }

    @Override
    public Object doGet(String key) {
        return Event.getVariableValueOrNull(key, this.event);
    }

    @Override
    public void doPut(String key, Object value) {
        this.eventBuider.addVariable(key, value);
        this.event = this.eventBuider.build();
    }

    @Override
    public void doRemove(String key) {
        this.eventBuider.removeVariable(key);
        this.event = this.eventBuider.build();
    }

    @Override
    public Set<String> keySet() {
        return this.event.getVariableNames();
    }

    @Override
    public void clear() {
        this.eventBuider.variables(Collections.emptyMap());
        this.event = this.eventBuider.build();
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.event.getVariableNames()) {
            Object value = this.event.getVariable(key) != null ? this.event.getVariable(key).getValue() : null;
            map.put(key, value);
        }
        return ((Object)map).toString();
    }
}

