/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.processor.InternalMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorChainBuilder;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.source.ClusterizableMessageSource;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.context.notification.PipelineMessageNotification;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.internal.construct.AbstractFlowConstruct;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.processor.IdempotentRedeliveryPolicy;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.TransactionAwareProcessingStrategyFactory;
import org.mule.runtime.core.source.ClusterizableMessageSourceWrapper;
import org.mule.runtime.core.streaming.StreamingManager;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractPipeline
extends AbstractFlowConstruct
implements Pipeline {
    protected MessageSource messageSource;
    protected MessageProcessorChain pipeline;
    protected final SchedulerService schedulerService;
    protected StreamingManager streamingManager;
    protected List<Processor> messageProcessors = Collections.emptyList();
    protected ProcessingStrategyFactory processingStrategyFactory;
    protected ProcessingStrategy processingStrategy;
    private boolean canProcessMessage = false;
    private Cache<String, EventContext> eventContextCache = CacheBuilder.newBuilder().weakValues().build();
    protected Sink sink;

    public AbstractPipeline(String name, MuleContext muleContext) {
        super(name, muleContext);
        this.schedulerService = muleContext.getSchedulerService();
        this.initialiseProcessingStrategy();
    }

    protected MessageProcessorChain createPipeline() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'" + this.getName() + "' processor chain");
        this.configurePreProcessors(builder);
        this.configureMessageProcessors(builder);
        this.configurePostProcessors(builder);
        return builder.build();
    }

    protected ProcessingStrategyFactory createDefaultProcessingStrategyFactory() {
        return new DirectProcessingStrategyFactory();
    }

    private void initialiseProcessingStrategy() {
        if (this.processingStrategy == null) {
            if (this.processingStrategyFactory == null) {
                ProcessingStrategyFactory defaultProcessingStrategyFactory = this.muleContext.getConfiguration().getDefaultProcessingStrategyFactory();
                this.processingStrategyFactory = defaultProcessingStrategyFactory == null ? this.createDefaultProcessingStrategyFactory() : defaultProcessingStrategyFactory;
            }
            this.processingStrategy = this.processingStrategyFactory.create(this.muleContext, this.getName());
        }
    }

    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain(new ProcessorStartCompleteProcessor());
    }

    protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain(new ProcessEndProcessor());
    }

    @Override
    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    @Override
    public List<Processor> getMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource instanceof ClusterizableMessageSource ? new ClusterizableMessageSourceWrapper(this.muleContext, (ClusterizableMessageSource)messageSource, this) : messageSource;
    }

    @Override
    public boolean isSynchronous() {
        return this.processingStrategy.isSynchronous();
    }

    @Override
    public ProcessingStrategyFactory getProcessingStrategyFactory() {
        return this.processingStrategyFactory;
    }

    @Override
    public void setProcessingStrategyFactory(ProcessingStrategyFactory processingStrategyFactory) {
        this.processingStrategyFactory = processingStrategyFactory;
        this.processingStrategy = null;
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    protected void doInitialise() throws MuleException {
        super.doInitialise();
        this.initialiseProcessingStrategy();
        this.streamingManager = this.muleContext.getRegistry().lookupObject(StreamingManager.class);
        this.pipeline = this.createPipeline();
        if (this.messageSource != null) {
            this.messageSource.setListener(new Processor(){

                @Override
                public Event process(Event event) throws MuleException {
                    if (AbstractPipeline.this.useBlockingCodePath()) {
                        return AbstractPipeline.this.pipeline.process(event);
                    }
                    return MessageProcessors.processToApply(event, this);
                }

                @Override
                public Publisher<Event> apply(Publisher<Event> publisher) {
                    return Flux.from(publisher).doOnNext(AbstractPipeline.this.assertStarted()).doOnNext(event -> AbstractPipeline.this.sink.accept((Event)event)).flatMap(event -> Mono.from(event.getContext().getResponsePublisher()));
                }
            });
        }
        this.injectFlowConstructMuleContext(this.messageSource);
        this.injectExceptionHandler(this.messageSource);
        this.injectFlowConstructMuleContext(this.pipeline);
        this.injectExceptionHandler(this.pipeline);
        this.initialiseIfInitialisable(this.messageSource);
        this.initialiseIfInitialisable(this.pipeline);
    }

    protected ReactiveProcessor processFlowFunction() {
        return stream -> Flux.from((Publisher)stream).transform((Function)this.processingStrategy.onPipeline(this.pipeline)).doOnNext(response -> response.getContext().success((Event)response)).doOnError(org.mule.runtime.core.api.rx.Exceptions.UNEXPECTED_EXCEPTION_PREDICATE, throwable -> LOGGER.error("Unhandled exception in async processing ", throwable));
    }

    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        for (Processor processor : this.getMessageProcessors()) {
            if (processor instanceof Processor) {
                builder.chain(processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)((Object)processor));
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
    }

    protected boolean isRedeliveryPolicyConfigured() {
        if (this.getMessageProcessors().isEmpty()) {
            return false;
        }
        return this.getMessageProcessors().get(0) instanceof IdempotentRedeliveryPolicy;
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        this.startIfStartable(this.processingStrategy);
        this.sink = this.processingStrategy.createSink(this, this.processFlowFunction());
        this.startIfStartable(this.pipeline);
        this.canProcessMessage = true;
        if (this.muleContext.isStarted()) {
            try {
                this.startIfStartable(this.messageSource);
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (MuleException e) {
                this.doStop();
                throw e;
            }
        }
    }

    public Consumer<Event> assertStarted() {
        return event -> {
            if (!this.canProcessMessage) {
                throw Exceptions.propagate((Throwable)((Object)new MessagingException((Event)event, (Throwable)new LifecycleException(CoreMessages.isStopped(this.getName()), (Object)event.getMessage()))));
            }
        };
    }

    @Override
    protected void doStop() throws MuleException {
        try {
            this.stopIfStoppable(this.messageSource);
        }
        finally {
            this.canProcessMessage = false;
        }
        this.disposeIfDisposable(this.sink);
        this.sink = null;
        this.stopIfStoppable(this.processingStrategy);
        this.stopIfStoppable(this.pipeline);
        super.doStop();
    }

    @Override
    protected void doDispose() {
        this.disposeIfDisposable(this.pipeline);
        this.disposeIfDisposable(this.messageSource);
        super.doDispose();
    }

    protected boolean useBlockingCodePath() {
        return TransactionCoordination.isTransactionActive() && (this.processingStrategy.isSynchronous() || this.processingStrategyFactory instanceof TransactionAwareProcessingStrategyFactory);
    }

    @Override
    public Map<String, EventContext> getSerializationEventContextCache() {
        return this.eventContextCache.asMap();
    }

    private class ProcessorStartCompleteProcessor
    implements Processor,
    InternalMessageProcessor {
        private ProcessorStartCompleteProcessor() {
        }

        @Override
        public Event process(Event event) throws MuleException {
            AbstractPipeline.this.muleContext.getNotificationManager().fireNotification(new PipelineMessageNotification(EnrichedNotificationInfo.createInfo(event, null, AbstractPipeline.this), AbstractPipeline.this, 1801));
            Mono.from(event.getContext().getBeforeResponsePublisher()).doOnNext(result -> this.fireCompleteNotification((Event)result, null)).doOnError(MessagingException.class, messagingException -> this.fireCompleteNotification(null, (MessagingException)((Object)messagingException))).doOnError(org.mule.runtime.core.api.rx.Exceptions.UNEXPECTED_EXCEPTION_PREDICATE, throwable -> this.fireCompleteNotification(null, new MessagingException(event, (Throwable)throwable, (Processor)(this instanceof Processor ? this : null)))).subscribe(Operators.requestUnbounded());
            return event;
        }

        private void fireCompleteNotification(Event event, MessagingException messagingException) {
            AbstractPipeline.this.muleContext.getNotificationManager().fireNotification(new PipelineMessageNotification(EnrichedNotificationInfo.createInfo(event, (Exception)((Object)messagingException), AbstractPipeline.this), AbstractPipeline.this, 1804));
        }
    }

    private class ProcessEndProcessor
    extends AbstractAnnotatedObject
    implements Processor,
    InternalMessageProcessor {
        private ProcessEndProcessor() {
        }

        @Override
        public Event process(Event event) throws MuleException {
            AbstractPipeline.this.muleContext.getNotificationManager().fireNotification(new PipelineMessageNotification(EnrichedNotificationInfo.createInfo(event, null, AbstractPipeline.this), AbstractPipeline.this, 1802));
            return event;
        }
    }
}

