/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.api.registry.LifecycleRegistry;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.registry.Registry;
import org.mule.runtime.core.api.registry.RegistryBroker;
import org.mule.runtime.core.api.registry.RegistryProvider;
import org.mule.runtime.core.lifecycle.RegistryBrokerLifecycleManager;

@Deprecated
public abstract class AbstractRegistryBroker
implements RegistryBroker,
RegistryProvider {
    protected RegistryBrokerLifecycleManager lifecycleManager;

    public AbstractRegistryBroker(MuleContext muleContext) {
        this.lifecycleManager = new RegistryBrokerLifecycleManager("mule.registry.broker", (Registry)this, muleContext);
    }

    public void initialise() throws InitialisationException {
        this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<AbstractRegistryBroker>(){

            @Override
            public void onTransition(String phaseName, AbstractRegistryBroker broker) throws MuleException {
                for (Registry registry : broker.getRegistries()) {
                    registry.initialise();
                }
            }
        });
    }

    public void dispose() {
        this.lifecycleManager.fireDisposePhase(new LifecycleCallback<AbstractRegistryBroker>(){

            @Override
            public void onTransition(String phaseName, AbstractRegistryBroker broker) throws MuleException {
                for (Registry registry : broker.getRegistries()) {
                    registry.dispose();
                }
            }
        });
    }

    @Override
    public void fireLifecycle(String phase) throws LifecycleException {
        if ("initialise".equals(phase)) {
            this.initialise();
        } else if ("dispose".equals(phase)) {
            this.dispose();
        } else {
            this.lifecycleManager.fireLifecycle(phase);
            for (Registry registry : this.getRegistries()) {
                registry.fireLifecycle(phase);
            }
        }
    }

    @Override
    public String getRegistryId() {
        return this.toString();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public <T> T get(String key) {
        return this.lookupObject(key);
    }

    @Override
    public <T> T lookupObject(String key) {
        Registry registry;
        T obj = null;
        Iterator iterator = this.getRegistries().iterator();
        while (iterator.hasNext() && (obj = (T)(registry = (Registry)iterator.next()).lookupObject(key)) == null) {
        }
        return obj;
    }

    public <T> T lookupObject(String key, boolean applyLifecycle) {
        for (Registry registry : this.getRegistries()) {
            Object obj;
            if (!(registry instanceof LifecycleRegistry) || (obj = ((LifecycleRegistry)registry).lookupObject(key, applyLifecycle)) == null) continue;
            return obj;
        }
        return this.lookupObject(key);
    }

    @Override
    public <T> T lookupObject(Class<T> type) throws RegistrationException {
        for (Registry registry : this.getRegistries()) {
            T object = registry.lookupObject(type);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> type) {
        ArrayList<T> objects = new ArrayList<T>();
        for (Registry registry : this.getRegistries()) {
            objects.addAll(registry.lookupObjects(type));
        }
        return objects;
    }

    @Override
    public <T> Collection<T> lookupLocalObjects(Class<T> type) {
        ArrayList<T> objects = new ArrayList<T>();
        for (Registry registry : this.getRegistries()) {
            objects.addAll(registry.lookupLocalObjects(type));
        }
        return objects;
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        HashMap<String, T> results = new HashMap<String, T>();
        for (Registry registry : this.getRegistries()) {
            results.putAll(registry.lookupByType(type));
        }
        return results;
    }

    @Override
    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        ArrayList<T> objects = new ArrayList<T>();
        for (Registry registry : this.getRegistries()) {
            objects.addAll(registry.lookupObjectsForLifecycle(type));
        }
        return objects;
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        for (Registry registry : this.getRegistries()) {
            if (registry.isReadOnly()) continue;
            registry.registerObject(key, value);
            break;
        }
    }

    @Override
    @Deprecated
    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registerObject(key, value);
    }

    public void registerObjects(Map objects) throws RegistrationException {
        for (Map.Entry entry : objects.entrySet()) {
            this.registerObject((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object unregisterObject(String key) throws RegistrationException {
        for (Registry registry : this.getRegistries()) {
            if (registry.isReadOnly() || registry.lookupObject(key) == null) continue;
            return registry.unregisterObject(key);
        }
        return null;
    }

    @Override
    @Deprecated
    public Object unregisterObject(String key, Object metadata) throws RegistrationException {
        return this.unregisterObject(key);
    }
}

