/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.api.util.Pair;

public class PartitionedObjectStoreWrapper<T extends Serializable>
implements ListableObjectStore<T> {
    String partitionName;
    MuleContext context;
    ListableObjectStore<T> baseStore;

    public PartitionedObjectStoreWrapper(String name, MuleContext context, ListableObjectStore<T> store) {
        this.partitionName = name;
        this.context = context;
        this.baseStore = store;
    }

    public boolean contains(Serializable key) throws ObjectStoreException {
        return this.getStore().contains(new Pair<String, Serializable>(this.partitionName, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Serializable key, T value) throws ObjectStoreException {
        Pair<String, Serializable> qKey = new Pair<String, Serializable>(this.partitionName, key);
        PartitionedObjectStoreWrapper partitionedObjectStoreWrapper = this;
        synchronized (partitionedObjectStoreWrapper) {
            if (this.getStore().contains(qKey)) {
                throw new ObjectAlreadyExistsException();
            }
            this.getStore().store(qKey, (Serializable)value);
        }
    }

    public T retrieve(Serializable key) throws ObjectStoreException {
        return (T)this.getStore().retrieve(new Pair<String, Serializable>(this.partitionName, key));
    }

    public void clear() throws ObjectStoreException {
        for (Serializable key : this.allKeys()) {
            this.remove(key);
        }
    }

    public T remove(Serializable key) throws ObjectStoreException {
        return (T)this.getStore().remove(new Pair<String, Serializable>(this.partitionName, key));
    }

    public boolean isPersistent() {
        return this.getStore().isPersistent();
    }

    @Override
    public void open() throws ObjectStoreException {
        this.getStore().open();
    }

    @Override
    public void close() throws ObjectStoreException {
        this.getStore().close();
    }

    @Override
    public List<Serializable> allKeys() throws ObjectStoreException {
        ArrayList<Serializable> results = new ArrayList<Serializable>();
        List<Serializable> keys = this.getStore().allKeys();
        for (Serializable key : keys) {
            Pair qKey = (Pair)key;
            if (!((String)qKey.getFirst()).equals(this.partitionName)) continue;
            results.add((Serializable)qKey.getSecond());
        }
        return results;
    }

    private ListableObjectStore<T> getStore() {
        return this.baseStore;
    }

    public ListableObjectStore<T> getBaseStore() {
        return this.getStore();
    }
}

