/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.JavaComponent;
import org.mule.runtime.core.api.component.LifecycleAdapter;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.model.EntryPointResolverSet;
import org.mule.runtime.core.api.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.runtime.core.component.ComponentException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.registry.JSR250ValidatorProcessor;
import org.mule.runtime.core.internal.util.annotation.AnnotationMetaData;
import org.mule.runtime.core.internal.util.annotation.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentLifecycleAdapter
implements LifecycleAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultComponentLifecycleAdapter.class);
    protected Object componentObject;
    protected JavaComponent component;
    protected EntryPointResolverSet entryPointResolver;
    protected FlowConstruct flowConstruct;
    protected boolean isInitialisable = false;
    protected boolean isStartable = false;
    protected boolean isStoppable = false;
    protected boolean isDisposable = false;
    protected Method initMethod;
    protected Method disposeMethod;
    private boolean started = false;
    private boolean disposed = false;
    protected MuleContext muleContext;

    public DefaultComponentLifecycleAdapter(Object componentObject, JavaComponent component, FlowConstruct flowConstruct, MuleContext muleContext) throws MuleException {
        if (muleContext == null) {
            throw new IllegalStateException("No muleContext provided");
        }
        if (componentObject == null) {
            throw new IllegalArgumentException("POJO Service cannot be null");
        }
        if (this.entryPointResolver == null) {
            this.entryPointResolver = new LegacyEntryPointResolverSet();
        }
        this.componentObject = componentObject;
        this.component = component;
        this.flowConstruct = flowConstruct;
        this.muleContext = muleContext;
        this.setLifecycleFlags();
    }

    public DefaultComponentLifecycleAdapter(Object componentObject, JavaComponent component, FlowConstruct flowConstruct, EntryPointResolverSet entryPointResolver, MuleContext muleContext) throws MuleException {
        this(componentObject, component, flowConstruct, muleContext);
        this.entryPointResolver = entryPointResolver;
    }

    protected void setLifecycleFlags() {
        Object object = this.componentObject;
        this.initMethod = this.findInitMethod(object);
        this.disposeMethod = this.findDisposeMethod(object);
        this.isInitialisable = this.initMethod != null;
        this.isDisposable = this.disposeMethod != null;
        this.isStartable = Startable.class.isInstance(object);
        this.isStoppable = Stoppable.class.isInstance(object);
    }

    protected Method findInitMethod(Object object) {
        List<AnnotationMetaData> metaData;
        if (object instanceof Initialisable) {
            try {
                return object.getClass().getMethod("initialise", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if ((metaData = AnnotationUtils.getMethodAnnotations(object.getClass(), PostConstruct.class)).size() == 0) {
            return null;
        }
        if (metaData.size() > 1) {
            throw new IllegalArgumentException(CoreMessages.objectHasMoreThanOnePostConstructAnnotation(object.getClass()).getMessage());
        }
        Method m = (Method)metaData.get(0).getMember();
        new JSR250ValidatorProcessor().validateLifecycleMethod(m);
        return m;
    }

    protected Method findDisposeMethod(Object object) {
        List<AnnotationMetaData> metaData;
        if (object instanceof Disposable) {
            try {
                return object.getClass().getMethod("dispose", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if ((metaData = AnnotationUtils.getMethodAnnotations(object.getClass(), PreDestroy.class)).size() == 0) {
            return null;
        }
        if (metaData.size() > 1) {
            throw new IllegalArgumentException(CoreMessages.objectHasMoreThanOnePreDestroyAnnotation(object.getClass()).getMessage());
        }
        Method m = (Method)metaData.get(0).getMember();
        new JSR250ValidatorProcessor().validateLifecycleMethod(m);
        return m;
    }

    public void initialise() throws InitialisationException {
        if (this.isInitialisable) {
            try {
                this.initMethod.invoke(this.componentObject, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
            catch (InvocationTargetException e) {
                throw new InitialisationException(e.getTargetException(), (Initialisable)this);
            }
        }
    }

    public void start() throws MuleException {
        if (this.isStartable) {
            try {
                ((Startable)this.componentObject).start();
                this.started = true;
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStart("Service: " + this.flowConstruct.getName()), (Throwable)e);
            }
        } else {
            this.started = true;
        }
    }

    public void stop() throws MuleException {
        if (this.isStoppable) {
            try {
                ((Stoppable)this.componentObject).stop();
                this.started = false;
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStop("Service: " + this.flowConstruct.getName()), (Throwable)e);
            }
        } else {
            this.started = false;
        }
    }

    public void dispose() {
        try {
            Object o;
            if (this.isDisposable && (o = this.componentObject) != null) {
                try {
                    this.disposeMethod.invoke(o, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            this.componentObject = null;
        }
        catch (Throwable e) {
            logger.error("failed to dispose: " + this.flowConstruct.getName(), e);
        }
        this.disposed = true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public Object invoke(Event event, Event.Builder eventBuilder) throws MuleException {
        Object result;
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        try {
            if (this.componentObject == null) {
                throw new ComponentException(I18nMessageFactory.createStaticMessage((String)"componentObject is null"), this.component);
            }
            result = this.component.getEntryPointResolverSet() != null ? this.component.getEntryPointResolverSet().invoke(this.componentObject, eventContext, eventBuilder) : this.entryPointResolver.invoke(this.componentObject, eventContext, eventBuilder);
        }
        catch (Exception e) {
            throw new ComponentException(I18nMessageFactory.createStaticMessage((String)"%s: %s", (Object[])new Object[]{e.getClass().getName(), e.getMessage()}), this.component, e);
        }
        return result;
    }
}

