/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.outbound;

import java.util.ArrayList;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.runtime.core.api.routing.RoutePathNotFoundException;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.api.transport.LegacyOutboundEndpoint;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.message.GroupCorrelation;
import org.mule.runtime.core.routing.AbstractRoutingStrategy;
import org.mule.runtime.core.routing.outbound.FilteringOutboundRouter;

public abstract class AbstractSequenceRouter
extends FilteringOutboundRouter {
    @Override
    public Event route(Event event) throws RoutingException {
        Message message = event.getMessage();
        if (this.routes == null || this.routes.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), null);
        }
        Event.Builder builder = Event.builder(event).groupCorrelation(new GroupCorrelation(this.routes.size(), null));
        ArrayList<Event> results = new ArrayList<Event>(this.routes.size());
        try {
            for (int i = 0; i < this.routes.size(); ++i) {
                Processor mp = this.getRoute(i, event);
                boolean filterAccepted = !(mp instanceof LegacyOutboundEndpoint) || ((LegacyOutboundEndpoint)((Object)mp)).filterAccepts(message, builder);
                event = builder.build();
                builder = Event.builder(event);
                if (!filterAccepted) continue;
                AbstractRoutingStrategy.validateMessageIsNotConsumable(event, message);
                Event result = this.sendRequest(event, this.createEventToRoute(event, message), mp, true);
                if (result != null) {
                    results.add(result);
                }
                if (this.continueRoutingMessageAfter(result)) {
                    continue;
                }
                break;
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException((Processor)this.routes.get(0), e);
        }
        return this.resultsHandler.aggregateResults(results, builder.build());
    }

    protected abstract boolean continueRoutingMessageAfter(Event var1) throws MuleException;
}

