/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxGroupJoin;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.OpenHashSet;

final class FluxJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends FluxSource<TLeft, R> {
    final Publisher<? extends TRight> other;
    final Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector;
    final Supplier<? extends Queue<Object>> queueSupplier;

    FluxJoin(Flux<TLeft> source, Publisher<? extends TRight> other, Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector, Supplier<? extends Queue<Object>> queueSupplier) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
        this.leftEnd = Objects.requireNonNull(leftEnd, "leftEnd");
        this.rightEnd = Objects.requireNonNull(rightEnd, "rightEnd");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
        this.resultSelector = Objects.requireNonNull(resultSelector, "resultSelector");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        JoinSubscription parent = new JoinSubscription(s, this.leftEnd, this.rightEnd, this.resultSelector, this.queueSupplier.get());
        s.onSubscribe(parent);
        FluxGroupJoin.LeftRightSubscriber left = new FluxGroupJoin.LeftRightSubscriber(parent, true);
        parent.cancellations.add(left);
        FluxGroupJoin.LeftRightSubscriber right = new FluxGroupJoin.LeftRightSubscriber(parent, false);
        parent.cancellations.add(right);
        this.source.subscribe((Subscriber)left);
        this.other.subscribe((Subscriber)right);
    }

    static final class JoinSubscription<TLeft, TRight, TLeftEnd, TRightEnd, R>
    implements FluxGroupJoin.JoinSupport,
    InnerProducer<R> {
        final Queue<Object> queue;
        final BiPredicate<Object, Object> queueBiOffer;
        final OpenHashSet<Disposable> cancellations;
        final Map<Integer, TLeft> lefts;
        final Map<Integer, TRight> rights;
        final Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd;
        final Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd;
        final BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector;
        final Subscriber<? super R> actual;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<JoinSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(JoinSubscription.class, "wip");
        volatile int active;
        static final AtomicIntegerFieldUpdater<JoinSubscription> ACTIVE = AtomicIntegerFieldUpdater.newUpdater(JoinSubscription.class, "active");
        volatile long requested;
        static final AtomicLongFieldUpdater<JoinSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(JoinSubscription.class, "requested");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<JoinSubscription, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(JoinSubscription.class, Throwable.class, "error");
        volatile boolean cancelled;
        int leftIndex;
        int rightIndex;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        JoinSubscription(Subscriber<? super R> actual, Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector, Queue<Object> queue) {
            this.actual = actual;
            this.cancellations = new OpenHashSet();
            this.queue = queue;
            if (!(queue instanceof BiPredicate)) {
                throw new IllegalArgumentException("The provided queue must implement BiPredicate to expose atomic dual insert");
            }
            this.queueBiOffer = (BiPredicate)((Object)queue);
            this.lefts = new LinkedHashMap<Integer, TLeft>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            ACTIVE.lazySet(this, 2);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.cancellations.keys()).map(Scannable::from);
        }

        @Override
        public final Subscriber<? super R> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case CANCELLED: {
                    return this.cancelled;
                }
                case BUFFERED: {
                    return this.queue.size() / 2;
                }
                case TERMINATED: {
                    return this.active == 0;
                }
                case ERROR: {
                    return this.error;
                }
            }
            return InnerProducer.super.scan(key);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.clear();
            }
        }

        void cancelAll() {
            Object[] a;
            for (Object o : a = this.cancellations.keys()) {
                if (o == null) continue;
                ((Disposable)o).dispose();
            }
        }

        void errorAll(Subscriber<?> a) {
            Throwable ex = Exceptions.terminate(ERROR, this);
            this.lefts.clear();
            this.rights.clear();
            a.onError(ex);
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            Queue<Object> q = this.queue;
            Subscriber<? super R> a = this.actual;
            block8: while (true) {
                boolean empty;
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                Throwable ex = this.error;
                if (ex != null) {
                    q.clear();
                    this.cancelAll();
                    this.errorAll(a);
                    return;
                }
                boolean d = this.active == 0;
                Integer mode = (Integer)q.poll();
                boolean bl = empty = mode == null;
                if (d && empty) {
                    Object[] c;
                    this.lefts.clear();
                    this.rights.clear();
                    for (Object o : c = this.cancellations.keys()) {
                        if (o == null) continue;
                        ((Disposable)o).dispose();
                    }
                    a.onComplete();
                    return;
                }
                if (!empty) {
                    FluxGroupJoin.LeftRightEndSubscriber end;
                    R w;
                    long e;
                    long r;
                    FluxGroupJoin.LeftRightEndSubscriber end2;
                    Object p;
                    int idx;
                    Object val = q.poll();
                    if (mode == LEFT_VALUE) {
                        Object left = val;
                        ++this.leftIndex;
                        this.lefts.put(idx, left);
                        try {
                            p = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, exc, left));
                            this.errorAll(a);
                            return;
                        }
                        end2 = new FluxGroupJoin.LeftRightEndSubscriber(this, true, idx);
                        this.cancellations.add(end2);
                        p.subscribe((Subscriber)end2);
                        ex = this.error;
                        if (ex != null) {
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        r = this.requested;
                        e = 0L;
                        for (TRight right : this.rights.values()) {
                            try {
                                w = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, exc, right));
                                this.errorAll(a);
                                return;
                            }
                            if (e != r) {
                                a.onNext(w);
                                ++e;
                                continue;
                            }
                            Exceptions.addThrowable(ERROR, this, Exceptions.failWithOverflow("Could not emit value due to lack of requests"));
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        if (e == 0L) continue;
                        while (true) {
                            if (r == Long.MAX_VALUE) continue block8;
                            long upd = r - e;
                            if (upd < 0L) {
                                Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, Exceptions.failWithOverflow()));
                                this.errorAll(a);
                                return;
                            }
                            if (REQUESTED.compareAndSet(this, r, upd)) continue block8;
                            r = this.requested;
                        }
                    }
                    if (mode == RIGHT_VALUE) {
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, exc, right));
                            this.errorAll(a);
                            return;
                        }
                        end2 = new FluxGroupJoin.LeftRightEndSubscriber(this, false, idx);
                        this.cancellations.add(end2);
                        p.subscribe((Subscriber)end2);
                        ex = this.error;
                        if (ex != null) {
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        r = this.requested;
                        e = 0L;
                        for (TLeft left : this.lefts.values()) {
                            try {
                                w = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, exc, left));
                                this.errorAll(a);
                                return;
                            }
                            if (e != r) {
                                a.onNext(w);
                                ++e;
                                continue;
                            }
                            Exceptions.addThrowable(ERROR, this, Exceptions.failWithOverflow("Could not emit value due to lack of requests"));
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        if (e == 0L) continue;
                        while (true) {
                            if (r == Long.MAX_VALUE) continue block8;
                            long upd = r - e;
                            if (upd < 0L) {
                                Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, Exceptions.failWithOverflow()));
                                this.errorAll(a);
                                return;
                            }
                            if (REQUESTED.compareAndSet(this, r, upd)) continue block8;
                            r = this.requested;
                        }
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (FluxGroupJoin.LeftRightEndSubscriber)val;
                        this.lefts.remove(end.index);
                        this.cancellations.remove(end);
                        continue;
                    }
                    if (mode != RIGHT_CLOSE) continue;
                    end = (FluxGroupJoin.LeftRightEndSubscriber)val;
                    this.rights.remove(end.index);
                    this.cancellations.remove(end);
                    continue;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex) {
            if (Exceptions.addThrowable(ERROR, this, ex)) {
                ACTIVE.decrementAndGet(this);
                this.drain();
            } else {
                Operators.onErrorDropped(ex);
            }
        }

        @Override
        public void innerComplete(FluxGroupJoin.LeftRightSubscriber sender) {
            this.cancellations.remove(sender);
            ACTIVE.decrementAndGet(this);
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o) {
            JoinSubscription joinSubscription = this;
            synchronized (joinSubscription) {
                this.queueBiOffer.test(isLeft ? LEFT_VALUE : RIGHT_VALUE, o);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, FluxGroupJoin.LeftRightEndSubscriber index) {
            JoinSubscription joinSubscription = this;
            synchronized (joinSubscription) {
                this.queueBiOffer.test(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex) {
            if (Exceptions.addThrowable(ERROR, this, ex)) {
                this.drain();
            } else {
                Operators.onErrorDropped(ex);
            }
        }
    }
}

