/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Disposable;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class FluxSubscribeOnValue<T>
extends Flux<T>
implements Fuseable {
    final T value;
    final Scheduler scheduler;

    FluxSubscribeOnValue(T value, Scheduler scheduler) {
        this.value = value;
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public void subscribe(Subscriber<? super T> s) {
        T v = this.value;
        if (v == null) {
            ScheduledEmpty parent = new ScheduledEmpty(s);
            s.onSubscribe((Subscription)parent);
            Cancellation f = this.scheduler.schedule(parent);
            if (f == Scheduler.REJECTED) {
                if (parent.future != Flux.CANCELLED) {
                    s.onError((Throwable)Operators.onRejectedExecution());
                }
            } else {
                parent.setFuture(f);
            }
        } else {
            s.onSubscribe(new ScheduledScalar<T>(s, v, this.scheduler));
        }
    }

    static final class ScheduledEmpty
    implements Fuseable.QueueSubscription<Void>,
    Runnable {
        final Subscriber<?> actual;
        volatile Cancellation future;
        static final AtomicReferenceFieldUpdater<ScheduledEmpty, Cancellation> FUTURE = AtomicReferenceFieldUpdater.newUpdater(ScheduledEmpty.class, Cancellation.class, "future");
        static final Disposable FINISHED = () -> {};

        ScheduledEmpty(Subscriber<?> actual) {
            this.actual = actual;
        }

        public void request(long n) {
            Operators.validate(n);
        }

        public void cancel() {
            Cancellation f = this.future;
            if (f != Flux.CANCELLED && f != FINISHED && (f = FUTURE.getAndSet(this, Flux.CANCELLED)) != null && f != Flux.CANCELLED && f != FINISHED) {
                f.dispose();
            }
        }

        @Override
        public void run() {
            try {
                this.actual.onComplete();
            }
            finally {
                FUTURE.lazySet(this, FINISHED);
            }
        }

        void setFuture(Cancellation f) {
            Cancellation a;
            if (!FUTURE.compareAndSet(this, null, f) && (a = this.future) != FINISHED && a != Flux.CANCELLED) {
                f.dispose();
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            return requestedMode & 2;
        }

        @Override
        public Void poll() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }
    }

    static final class ScheduledScalar<T>
    implements Fuseable.QueueSubscription<T>,
    InnerProducer<T>,
    Runnable {
        final Subscriber<? super T> actual;
        final T value;
        final Scheduler scheduler;
        volatile int once;
        static final AtomicIntegerFieldUpdater<ScheduledScalar> ONCE = AtomicIntegerFieldUpdater.newUpdater(ScheduledScalar.class, "once");
        volatile Cancellation future;
        static final AtomicReferenceFieldUpdater<ScheduledScalar, Cancellation> FUTURE = AtomicReferenceFieldUpdater.newUpdater(ScheduledScalar.class, Cancellation.class, "future");
        static final Cancellation FINISHED = () -> {};
        int fusionState;
        static final int NO_VALUE = 1;
        static final int HAS_VALUE = 2;
        static final int COMPLETE = 3;

        ScheduledScalar(Subscriber<? super T> actual, T value, Scheduler scheduler) {
            this.actual = actual;
            this.value = value;
            this.scheduler = scheduler;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.future == Flux.CANCELLED;
                }
                case TERMINATED: {
                    return this.future == FINISHED;
                }
                case BUFFERED: {
                    return this.value != null ? 1 : 0;
                }
            }
            return InnerProducer.super.scan(key);
        }

        public void request(long n) {
            if (Operators.validate(n) && ONCE.compareAndSet(this, 0, 1)) {
                Cancellation f = this.scheduler.schedule(this);
                if (f == Scheduler.REJECTED && this.future != FINISHED && this.future != Flux.CANCELLED) {
                    this.actual.onError((Throwable)Operators.onRejectedExecution(this, null, null));
                } else if (!FUTURE.compareAndSet(this, null, f) && this.future != FINISHED && this.future != Flux.CANCELLED) {
                    f.dispose();
                }
            }
        }

        public void cancel() {
            ONCE.lazySet(this, 1);
            Cancellation f = this.future;
            if (f != Flux.CANCELLED && this.future != FINISHED && (f = FUTURE.getAndSet(this, Flux.CANCELLED)) != null && f != Flux.CANCELLED && f != FINISHED) {
                f.dispose();
            }
        }

        @Override
        public void run() {
            try {
                if (this.fusionState == 1) {
                    this.fusionState = 2;
                }
                this.actual.onNext(this.value);
                this.actual.onComplete();
            }
            finally {
                FUTURE.lazySet(this, FINISHED);
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.fusionState = 1;
                return 2;
            }
            return 0;
        }

        @Override
        public T poll() {
            if (this.fusionState == 2) {
                this.fusionState = 3;
                return this.value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.fusionState != 2;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public void clear() {
            this.fusionState = 3;
        }
    }
}

