/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxTake<T>
extends FluxSource<T, T> {
    final long n;

    FluxTake(Flux<? extends T> source, long n) {
        super(source);
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + n);
        }
        this.n = n;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new TakeConditionalSubscriber((Fuseable.ConditionalSubscriber)s, this.n));
        } else {
            this.source.subscribe(new TakeSubscriber<T>(s, this.n));
        }
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    static final class TakeFuseableSubscriber<T>
    implements Fuseable.QueueSubscription<T>,
    InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        final long n;
        long remaining;
        Fuseable.QueueSubscription<T> qs;
        boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<TakeFuseableSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(TakeFuseableSubscriber.class, "wip");
        int inputMode;

        TakeFuseableSubscriber(Subscriber<? super T> actual, long n) {
            this.actual = actual;
            this.n = n;
            this.remaining = n;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.qs, s)) {
                this.qs = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe((Subscription)this);
                if (this.inputMode != 1 && this.n == 0L && this.wip == 0) {
                    this.request(Long.MAX_VALUE);
                }
            }
        }

        public void onNext(T t) {
            if (this.inputMode == 2) {
                this.actual.onNext(null);
                return;
            }
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            long r = this.remaining;
            if (r == 0L) {
                this.qs.cancel();
                this.onComplete();
                return;
            }
            this.remaining = --r;
            boolean stop = r == 0L;
            this.actual.onNext(t);
            if (stop) {
                this.qs.cancel();
                this.onComplete();
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void request(long n) {
            if (this.wip != 0) {
                this.qs.request(n);
            } else if (WIP.compareAndSet(this, 0, 1)) {
                if (n >= this.n) {
                    this.qs.request(Long.MAX_VALUE);
                } else {
                    this.qs.request(n);
                }
            }
        }

        public void cancel() {
            this.qs.cancel();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.qs;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            this.inputMode = m = this.qs.requestFusion(requestedMode);
            return m;
        }

        @Override
        public T poll() {
            if (this.done) {
                return null;
            }
            long r = this.remaining;
            Object v = this.qs.poll();
            if (r == 0L) {
                this.done = true;
                if (this.inputMode == 2) {
                    this.qs.cancel();
                    this.actual.onComplete();
                }
                return null;
            }
            if (v != null) {
                this.remaining = --r;
                if (r == 0L && !this.done) {
                    this.done = true;
                    if (this.inputMode == 2) {
                        this.qs.cancel();
                        this.actual.onComplete();
                    }
                }
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.remaining == 0L || this.qs.isEmpty();
        }

        @Override
        public void clear() {
            this.qs.clear();
        }

        @Override
        public int size() {
            return this.qs.size();
        }
    }

    static final class TakeConditionalSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final long n;
        long remaining;
        Subscription s;
        boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<TakeConditionalSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(TakeConditionalSubscriber.class, "wip");

        TakeConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, long n) {
            this.actual = actual;
            this.n = n;
            this.remaining = n;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                if (this.n == 0L && this.wip == 0) {
                    this.request(Long.MAX_VALUE);
                }
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            long r = this.remaining;
            if (r == 0L) {
                this.s.cancel();
                this.onComplete();
                return;
            }
            this.remaining = --r;
            boolean stop = r == 0L;
            this.actual.onNext(t);
            if (stop) {
                this.s.cancel();
                this.onComplete();
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            long r = this.remaining;
            if (r == 0L) {
                this.s.cancel();
                this.onComplete();
                return true;
            }
            this.remaining = --r;
            boolean stop = r == 0L;
            boolean b = this.actual.tryOnNext(t);
            if (stop) {
                this.s.cancel();
                this.onComplete();
            }
            return b;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void request(long n) {
            if (this.wip != 0) {
                this.s.request(n);
            } else if (WIP.compareAndSet(this, 0, 1)) {
                if (n >= this.n) {
                    this.s.request(Long.MAX_VALUE);
                } else {
                    this.s.request(n);
                }
            }
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }
    }

    static final class TakeSubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        final long n;
        long remaining;
        Subscription s;
        boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<TakeSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(TakeSubscriber.class, "wip");

        public TakeSubscriber(Subscriber<? super T> actual, long n) {
            this.actual = actual;
            this.n = n;
            this.remaining = n;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                if (this.n == 0L && this.wip == 0) {
                    this.request(Long.MAX_VALUE);
                }
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            long r = this.remaining;
            if (r == 0L) {
                this.s.cancel();
                this.onComplete();
                return;
            }
            this.remaining = --r;
            boolean stop = r == 0L;
            this.actual.onNext(t);
            if (stop) {
                this.s.cancel();
                this.onComplete();
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void request(long n) {
            if (this.wip != 0) {
                this.s.request(n);
            } else if (WIP.compareAndSet(this, 0, 1)) {
                if (n >= this.n) {
                    this.s.request(Long.MAX_VALUE);
                } else {
                    this.s.request(n);
                }
            }
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }
    }
}

