/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoError<T>
extends Mono<T> {
    final Throwable error;

    MonoError(Throwable error) {
        this.error = Objects.requireNonNull(error, "error");
    }

    @Override
    public T block(Duration m) {
        throw Exceptions.propagate(this.error);
    }

    @Override
    public T block() {
        throw Exceptions.propagate(this.error);
    }

    public void subscribe(Subscriber<? super T> s) {
        Operators.error(s, Operators.onOperatorError(this.error));
    }
}

