/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class MonoPublishOn<T>
extends MonoSource<T, T> {
    final Scheduler scheduler;

    MonoPublishOn(Mono<? extends T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new PublishOnSubscriber<T>(s, this.scheduler));
    }

    static final class PublishOnSubscriber<T>
    implements InnerOperator<T, T>,
    Runnable {
        final Subscriber<? super T> actual;
        final Scheduler scheduler;
        Subscription s;
        volatile Cancellation future;
        static final AtomicReferenceFieldUpdater<PublishOnSubscriber, Cancellation> FUTURE = AtomicReferenceFieldUpdater.newUpdater(PublishOnSubscriber.class, Cancellation.class, "future");
        T value;
        Throwable error;

        PublishOnSubscriber(Subscriber<? super T> actual, Scheduler scheduler) {
            this.actual = actual;
            this.scheduler = scheduler;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.future == Flux.CANCELLED;
                }
                case PARENT: {
                    return this.s;
                }
                case ERROR: {
                    return this.error;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.value = t;
            if (this.schedule() == Scheduler.REJECTED) {
                throw Operators.onRejectedExecution(this, null, t);
            }
        }

        public void onError(Throwable t) {
            this.error = t;
            if (this.schedule() == Scheduler.REJECTED) {
                throw Operators.onRejectedExecution(null, t, null);
            }
        }

        public void onComplete() {
            if (this.value == null && this.schedule() == Scheduler.REJECTED && this.future != Flux.CANCELLED) {
                throw Operators.onRejectedExecution();
            }
        }

        Cancellation schedule() {
            if (this.future == null) {
                Cancellation c = this.scheduler.schedule(this);
                if (!FUTURE.compareAndSet(this, null, c)) {
                    c.dispose();
                }
                return c;
            }
            return null;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            Cancellation c = this.future;
            if (c != Flux.CANCELLED && (c = FUTURE.getAndSet(this, Flux.CANCELLED)) != null && c != Flux.CANCELLED) {
                c.dispose();
            }
            this.s.cancel();
        }

        @Override
        public void run() {
            if (this.future == Flux.CANCELLED) {
                return;
            }
            T v = this.value;
            this.value = null;
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.future == Flux.CANCELLED) {
                return;
            }
            Throwable e = this.error;
            if (e != null) {
                this.actual.onError(e);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

