/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.TimeUnit;
import reactor.core.Cancellation;
import reactor.core.Disposable;
import reactor.core.scheduler.RejectedDisposable;

public interface Scheduler
extends Disposable {
    public static final Disposable REJECTED = new RejectedDisposable();

    public Cancellation schedule(Runnable var1);

    default public Cancellation schedule(Runnable task, long delay, TimeUnit unit) {
        return REJECTED;
    }

    default public Cancellation schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return REJECTED;
    }

    default public long now(TimeUnit unit) {
        return unit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public Worker createWorker();

    @Override
    default public void dispose() {
        this.shutdown();
    }

    default public void start() {
    }

    @Deprecated
    default public void shutdown() {
    }

    public static interface Worker
    extends Disposable {
        public Cancellation schedule(Runnable var1);

        default public Cancellation schedule(Runnable task, long delay, TimeUnit unit) {
            return REJECTED;
        }

        default public Cancellation schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            return REJECTED;
        }

        @Deprecated
        public void shutdown();

        @Override
        default public void dispose() {
            this.shutdown();
        }
    }
}

