/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;

public class ArrayFoldRight
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("array", "http://www.w3.org/2005/xpath-functions/array", "fold-right");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{ArrayItem.SINGLE_ARRAY_TYPE, SequenceType.ANY_SEQUENCE, SequenceType.makeSequenceType(new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE), 16384)};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                ArrayItem array = (ArrayItem)arguments[0].head();
                assert (array != null);
                Sequence zero = arguments[1].head();
                Function fn = (Function)arguments[2].head();
                for (int i = array.size() - 1; i >= 0; --i) {
                    zero = fn.call(context, new Sequence[]{array.get(i), zero});
                }
                return zero;
            }
        };
    }
}

