/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public abstract class AbstractStaticContext
implements StaticContext {
    private String baseURI = null;
    private Configuration config;
    private PackageData packageData;
    private Location containingLocation = ExplicitLocation.UNKNOWN_LOCATION;
    private String defaultCollationName;
    private FunctionLibraryList libraryList = new FunctionLibraryList();
    private String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
    private String defaultElementNamespace = "";
    private boolean backwardsCompatible = false;
    private int xpathLanguageLevel = 30;
    protected boolean usingDefaultFunctionLibrary;

    protected void setConfiguration(Configuration config) {
        this.config = config;
        this.defaultCollationName = config.getDefaultCollationName();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setPackageData(PackageData packageData) {
        this.packageData = packageData;
    }

    public PackageData getPackageData() {
        return this.packageData;
    }

    public void setSchemaAware(boolean aware) {
        this.getPackageData().setSchemaAware(aware);
    }

    public RetainedStaticContext makeRetainedStaticContext() {
        return new RetainedStaticContext(this);
    }

    protected final void setDefaultFunctionLibrary() {
        FunctionLibraryList lib = new FunctionLibraryList();
        int features = 1;
        if (this.getXPathVersion() >= 30) {
            features |= 0x10;
        }
        if (this.getXPathVersion() >= 31) {
            features |= 0x80;
        }
        lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(features, this.config));
        lib.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        lib.addFunctionLibrary(this.config.getIntegratedFunctionLibrary());
        this.config.addExtensionBinders(lib);
        this.setFunctionLibrary(lib);
    }

    protected final void addFunctionLibrary(FunctionLibrary library) {
        this.libraryList.addFunctionLibrary(library);
    }

    public int getHostLanguage() {
        return 54;
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration());
    }

    public Location getContainingLocation() {
        return this.containingLocation;
    }

    public void setContainingLocation(Location location) {
        this.containingLocation = location;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getStaticBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.libraryList;
    }

    public void setFunctionLibrary(FunctionLibraryList lib) {
        this.libraryList = lib;
        this.usingDefaultFunctionLibrary = false;
    }

    public void declareCollation(String name, StringCollator comparator, boolean isDefault) {
        this.getConfiguration().registerCollation(name, comparator);
        if (isDefault) {
            this.defaultCollationName = name;
        }
    }

    public void setDefaultCollationName(String collationName) {
        this.defaultCollationName = collationName;
    }

    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public void issueWarning(String s, Location locator) {
        XPathException xe = new XPathException(s);
        xe.setLocation(locator);
        this.config.getErrorListener().warning(xe);
    }

    public String getSystemId() {
        return "";
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
    }

    public void setDefaultFunctionNamespace(String uri) {
        this.defaultFunctionNamespace = uri;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setXPathLanguageLevel(int level) {
        this.xpathLanguageLevel = level;
        if (this.packageData != null) {
            this.packageData.setXPathVersion(level);
        }
        if (this.usingDefaultFunctionLibrary) {
            FunctionLibraryList liblist = (FunctionLibraryList)this.getFunctionLibrary();
            List<FunctionLibrary> list = liblist.getLibraryList();
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof SystemFunctionLibrary)) continue;
                int features = 1;
                if (this.getXPathVersion() >= 30) {
                    features |= 0x10;
                }
                if (this.getXPathVersion() >= 31) {
                    features |= 0x80;
                }
                list.set(i, SystemFunctionLibrary.getSystemFunctionLibrary(features, this.config));
                break;
            }
        }
    }

    public int getXPathVersion() {
        return this.xpathLanguageLevel;
    }

    public void setBackwardsCompatibilityMode(boolean option) {
        this.backwardsCompatible = option;
    }

    public boolean isInBackwardsCompatibleMode() {
        return this.backwardsCompatible;
    }

    public void setDecimalFormatManager(DecimalFormatManager manager) {
        this.getPackageData().setDecimalFormatManager(manager);
    }

    public ItemType getRequiredContextItemType() {
        return AnyItemType.getInstance();
    }

    public DecimalFormatManager getDecimalFormatManager() {
        DecimalFormatManager manager = this.getPackageData().getDecimalFormatManager();
        if (manager == null) {
            manager = new DecimalFormatManager(54, this.xpathLanguageLevel);
            this.getPackageData().setDecimalFormatManager(manager);
        }
        return manager;
    }

    public KeyManager getKeyManager() {
        return this.getPackageData().getKeyManager();
    }
}

