/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxDelaySubscription<T, U>
extends FluxSource<T, T> {
    final Publisher<U> other;

    FluxDelaySubscription(Flux<? extends T> source, Publisher<U> other) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.other.subscribe(new DelaySubscriptionOtherSubscriber(s, this.source));
    }

    static final class DelaySubscriptionOtherSubscriber<T, U>
    extends Operators.DeferredSubscription
    implements InnerOperator<U, T> {
        final Publisher<? extends T> source;
        final Subscriber<? super T> actual;
        Subscription s;
        boolean done;

        DelaySubscriptionOtherSubscriber(Subscriber<? super T> actual, Publisher<? extends T> source) {
            this.actual = actual;
            this.source = source;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void cancel() {
            this.s.cancel();
            super.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(U t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.s.cancel();
            this.subscribeSource();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.subscribeSource();
        }

        void subscribeSource() {
            this.source.subscribe(new DelaySubscriptionMainSubscriber<T>(this.actual, this));
        }

        static final class DelaySubscriptionMainSubscriber<T>
        implements InnerConsumer<T> {
            final Subscriber<? super T> actual;
            final DelaySubscriptionOtherSubscriber<?, ?> arbiter;

            DelaySubscriptionMainSubscriber(Subscriber<? super T> actual, DelaySubscriptionOtherSubscriber<?, ?> arbiter) {
                this.actual = actual;
                this.arbiter = arbiter;
            }

            @Override
            public Object scan(Scannable.Attr key) {
                switch (key) {
                    case ACTUAL: {
                        return this.actual;
                    }
                }
                return null;
            }

            public void onSubscribe(Subscription s) {
                this.arbiter.set(s);
            }

            public void onNext(T t) {
                this.actual.onNext(t);
            }

            public void onError(Throwable t) {
                this.actual.onError(t);
            }

            public void onComplete() {
                this.actual.onComplete();
            }
        }
    }
}

