/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalPeek;

final class FluxPeekFuseable<T>
extends FluxSource<T, T>
implements Fuseable,
SignalPeek<T> {
    final Consumer<? super Subscription> onSubscribeCall;
    final Consumer<? super T> onNextCall;
    final Consumer<? super Throwable> onErrorCall;
    final Runnable onCompleteCall;
    final Runnable onAfterTerminateCall;
    final LongConsumer onRequestCall;
    final Runnable onCancelCall;

    FluxPeekFuseable(Flux<? extends T> source, Consumer<? super Subscription> onSubscribeCall, Consumer<? super T> onNextCall, Consumer<? super Throwable> onErrorCall, Runnable onCompleteCall, Runnable onAfterTerminateCall, LongConsumer onRequestCall, Runnable onCancelCall) {
        super(source);
        this.onSubscribeCall = onSubscribeCall;
        this.onNextCall = onNextCall;
        this.onErrorCall = onErrorCall;
        this.onCompleteCall = onCompleteCall;
        this.onAfterTerminateCall = onAfterTerminateCall;
        this.onRequestCall = onRequestCall;
        this.onCancelCall = onCancelCall;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new PeekFuseableConditionalSubscriber((Fuseable.ConditionalSubscriber)s, this));
            return;
        }
        this.source.subscribe(new PeekFuseableSubscriber<T>(s, this));
    }

    @Override
    public Consumer<? super Subscription> onSubscribeCall() {
        return this.onSubscribeCall;
    }

    @Override
    public Consumer<? super T> onNextCall() {
        return this.onNextCall;
    }

    @Override
    public Consumer<? super Throwable> onErrorCall() {
        return this.onErrorCall;
    }

    @Override
    public Runnable onCompleteCall() {
        return this.onCompleteCall;
    }

    @Override
    public Runnable onAfterTerminateCall() {
        return this.onAfterTerminateCall;
    }

    @Override
    public LongConsumer onRequestCall() {
        return this.onRequestCall;
    }

    @Override
    public Runnable onCancelCall() {
        return this.onCancelCall;
    }

    static final class PeekConditionalSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final SignalPeek<T> parent;
        Subscription s;
        boolean done;

        PeekConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, SignalPeek<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            if (this.parent.onRequestCall() != null) {
                try {
                    this.parent.onRequestCall().accept(n);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.request(n);
        }

        public void cancel() {
            if (this.parent.onCancelCall() != null) {
                try {
                    this.parent.onCancelCall().run();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                if (this.parent.onSubscribeCall() != null) {
                    try {
                        this.parent.onSubscribeCall().accept(s);
                    }
                    catch (Throwable e) {
                        Operators.error(this.actual, Operators.onOperatorError(s, e));
                        return;
                    }
                }
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (this.parent.onNextCall() != null) {
                try {
                    this.parent.onNextCall().accept(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
            }
            this.actual.onNext(t);
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return false;
            }
            if (this.parent.onNextCall() != null) {
                try {
                    this.parent.onNextCall().accept(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return true;
                }
            }
            return this.actual.tryOnNext(t);
        }

        public void onError(Throwable t) {
            block9: {
                if (this.done) {
                    Operators.onErrorDropped(t);
                    return;
                }
                this.done = true;
                if (this.parent.onErrorCall() != null) {
                    Exceptions.throwIfFatal(t);
                    try {
                        this.parent.onErrorCall().accept(t);
                    }
                    catch (Throwable e) {
                        t = Operators.onOperatorError(null, e, t);
                    }
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (this.parent.onErrorCall() != null && (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t)) break block9;
                    throw use;
                }
            }
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().run();
                }
                catch (Throwable e) {
                    FluxPeek.afterErrorWithFailure(this.parent, e, t);
                }
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.parent.onCompleteCall() != null) {
                try {
                    this.parent.onCompleteCall().run();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.done = true;
            this.actual.onComplete();
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().run();
                }
                catch (Throwable e) {
                    FluxPeek.afterCompleteWithFailure(this.parent, e);
                }
            }
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }
    }

    static final class PeekFuseableConditionalSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final SignalPeek<T> parent;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;
        volatile boolean done;

        PeekFuseableConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, SignalPeek<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void request(long n) {
            if (this.parent.onRequestCall() != null) {
                try {
                    this.parent.onRequestCall().accept(n);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.request(n);
        }

        public void cancel() {
            if (this.parent.onCancelCall() != null) {
                try {
                    this.parent.onCancelCall().run();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                if (this.parent.onSubscribeCall() != null) {
                    try {
                        this.parent.onSubscribeCall().accept(s);
                    }
                    catch (Throwable e) {
                        Operators.error(this.actual, Operators.onOperatorError(s, e));
                        return;
                    }
                }
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                if (this.done) {
                    Operators.onNextDropped(t);
                    return;
                }
                if (this.parent.onNextCall() != null) {
                    try {
                        this.parent.onNextCall().accept(t);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e, t));
                        return;
                    }
                }
                this.actual.onNext(t);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return false;
            }
            if (this.parent.onNextCall() != null) {
                try {
                    this.parent.onNextCall().accept(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return true;
                }
            }
            return this.actual.tryOnNext(t);
        }

        public void onError(Throwable t) {
            block9: {
                if (this.done) {
                    Operators.onErrorDropped(t);
                    return;
                }
                this.done = true;
                if (this.parent.onErrorCall() != null) {
                    Exceptions.throwIfFatal(t);
                    try {
                        this.parent.onErrorCall().accept(t);
                    }
                    catch (Throwable e) {
                        t = Operators.onOperatorError(null, e, t);
                    }
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (this.parent.onErrorCall() != null && (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t)) break block9;
                    throw use;
                }
            }
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().run();
                }
                catch (Throwable e) {
                    FluxPeek.afterErrorWithFailure(this.parent, e, t);
                }
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 2) {
                this.done = true;
                this.actual.onComplete();
            } else {
                if (this.parent.onCompleteCall() != null) {
                    try {
                        this.parent.onCompleteCall().run();
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e));
                        return;
                    }
                }
                this.done = true;
                this.actual.onComplete();
                if (this.parent.onAfterTerminateCall() != null) {
                    try {
                        this.parent.onAfterTerminateCall().run();
                    }
                    catch (Throwable e) {
                        FluxPeek.afterCompleteWithFailure(this.parent, e);
                    }
                }
            }
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public T poll() {
            boolean d = this.done;
            Object v = this.s.poll();
            if (v != null && this.parent.onNextCall() != null) {
                try {
                    this.parent.onNextCall().accept(v);
                }
                catch (Throwable e) {
                    throw Exceptions.propagate(Operators.onOperatorError(this.s, e, v));
                }
            }
            if (v == null && (d || this.sourceMode == 1)) {
                Runnable call = this.parent.onCompleteCall();
                if (call != null) {
                    call.run();
                }
                if ((call = this.parent.onAfterTerminateCall()) != null) {
                    call.run();
                }
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            this.sourceMode = m = this.s.requestFusion(requestedMode);
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }

    static final class PeekFuseableSubscriber<T>
    implements InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final Subscriber<? super T> actual;
        final SignalPeek<T> parent;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;
        volatile boolean done;

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        PeekFuseableSubscriber(Subscriber<? super T> actual, SignalPeek<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            if (this.parent.onRequestCall() != null) {
                try {
                    this.parent.onRequestCall().accept(n);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.request(n);
        }

        public void cancel() {
            if (this.parent.onCancelCall() != null) {
                try {
                    this.parent.onCancelCall().run();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                if (this.parent.onSubscribeCall() != null) {
                    try {
                        this.parent.onSubscribeCall().accept(s);
                    }
                    catch (Throwable e) {
                        Operators.error(this.actual, Operators.onOperatorError(s, e));
                        return;
                    }
                }
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                if (this.done) {
                    Operators.onNextDropped(t);
                    return;
                }
                if (this.parent.onNextCall() != null) {
                    try {
                        this.parent.onNextCall().accept(t);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e, t));
                        return;
                    }
                }
                this.actual.onNext(t);
            }
        }

        public void onError(Throwable t) {
            block9: {
                if (this.done) {
                    Operators.onErrorDropped(t);
                    return;
                }
                this.done = true;
                if (this.parent.onErrorCall() != null) {
                    Exceptions.throwIfFatal(t);
                    try {
                        this.parent.onErrorCall().accept(t);
                    }
                    catch (Throwable e) {
                        t = Operators.onOperatorError(null, e, t);
                    }
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (this.parent.onErrorCall() != null && (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t)) break block9;
                    throw use;
                }
            }
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().run();
                }
                catch (Throwable e) {
                    FluxPeek.afterErrorWithFailure(this.parent, e, t);
                }
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 2) {
                this.done = true;
                this.actual.onComplete();
            } else {
                if (this.parent.onCompleteCall() != null) {
                    try {
                        this.parent.onCompleteCall().run();
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e));
                        return;
                    }
                }
                this.done = true;
                this.actual.onComplete();
                if (this.parent.onAfterTerminateCall() != null) {
                    try {
                        this.parent.onAfterTerminateCall().run();
                    }
                    catch (Throwable e) {
                        FluxPeek.afterCompleteWithFailure(this.parent, e);
                    }
                }
            }
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public T poll() {
            boolean d = this.done;
            Object v = this.s.poll();
            if (v != null && this.parent.onNextCall() != null) {
                try {
                    this.parent.onNextCall().accept(v);
                }
                catch (Throwable e) {
                    throw Exceptions.propagate(Operators.onOperatorError(this.s, e, v));
                }
            }
            if (v == null && (d || this.sourceMode == 1)) {
                Runnable call = this.parent.onCompleteCall();
                if (call != null) {
                    call.run();
                }
                if ((call = this.parent.onAfterTerminateCall()) != null) {
                    call.run();
                }
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            this.sourceMode = m = this.s.requestFusion(requestedMode);
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }
}

