/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxOnErrorResume;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;

final class MonoOnErrorResume<T>
extends MonoSource<T, T> {
    final Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory;

    MonoOnErrorResume(Mono<? extends T> source, Function<? super Throwable, ? extends Mono<? extends T>> nextFactory) {
        super(source);
        this.nextFactory = Objects.requireNonNull(nextFactory, "nextFactory");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new FluxOnErrorResume.ResumeSubscriber<T>(s, this.nextFactory));
    }
}

