/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class MonoSubscribeOn<T>
extends MonoSource<T, T> {
    final Scheduler scheduler;

    MonoSubscribeOn(Mono<? extends T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        SubscribeOnSubscriber<? super T> parent = new SubscribeOnSubscriber<T>(this.source, s, worker);
        s.onSubscribe(parent);
        if (worker.schedule(parent) == Scheduler.REJECTED && !worker.isDisposed()) {
            s.onError((Throwable)Operators.onRejectedExecution(parent, null, null));
        }
    }

    static final class SubscribeOnSubscriber<T>
    implements InnerOperator<T, T>,
    Runnable {
        final Subscriber<? super T> actual;
        final Publisher<? extends T> parent;
        final Scheduler.Worker worker;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<SubscribeOnSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(SubscribeOnSubscriber.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<SubscribeOnSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(SubscribeOnSubscriber.class, "requested");

        SubscribeOnSubscriber(Publisher<? extends T> parent, Subscriber<? super T> actual, Scheduler.Worker worker) {
            this.actual = actual;
            this.parent = parent;
            this.worker = worker;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
                case PARENT: {
                    return this.s;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public void run() {
            this.parent.subscribe((Subscriber)this);
        }

        public void onSubscribe(Subscription s) {
            if (!Operators.setOnce(S, this, s)) {
                s.cancel();
            } else {
                long r = REQUESTED.getAndSet(this, 0L);
                if (r != 0L && this.worker.schedule(() -> this.requestMore(r)) == Scheduler.REJECTED && !this.worker.isDisposed()) {
                    this.actual.onError((Throwable)Operators.onRejectedExecution(this, null, null));
                }
            }
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            try {
                this.actual.onError(t);
            }
            finally {
                this.worker.dispose();
            }
        }

        public void onComplete() {
            try {
                this.actual.onComplete();
            }
            finally {
                this.worker.dispose();
            }
        }

        public void request(long n) {
            if (Operators.validate(n) && this.worker.schedule(() -> this.requestMore(n)) == Scheduler.REJECTED && !this.worker.isDisposed()) {
                this.actual.onError((Throwable)Operators.onRejectedExecution(this, null, null));
            }
        }

        public void cancel() {
            if (Operators.terminate(S, this)) {
                this.worker.dispose();
            }
        }

        void requestMore(long n) {
            Subscription a = this.s;
            if (a != null) {
                a.request(n);
            } else {
                long r;
                Operators.getAndAddCap(REQUESTED, this, n);
                a = this.s;
                if (a != null && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                    a.request(r);
                }
            }
        }
    }
}

