/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import reactor.core.Cancellation;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxSubscribeOnCallable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class MonoSubscribeOnCallable<T>
extends Mono<T>
implements Fuseable {
    final Callable<? extends T> callable;
    final Scheduler scheduler;

    MonoSubscribeOnCallable(Callable<? extends T> callable, Scheduler scheduler) {
        this.callable = Objects.requireNonNull(callable, "callable");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public void subscribe(Subscriber<? super T> s) {
        FluxSubscribeOnCallable.CallableSubscribeOnSubscription<T> parent = new FluxSubscribeOnCallable.CallableSubscribeOnSubscription<T>(s, this.callable, this.scheduler);
        s.onSubscribe(parent);
        Cancellation f = this.scheduler.schedule(parent);
        if (f == Scheduler.REJECTED) {
            if (parent.state != 4) {
                s.onError((Throwable)Operators.onRejectedExecution());
            }
        } else {
            parent.setMainFuture(f);
        }
    }
}

