/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoThenIgnore<T>
extends Mono<T>
implements Fuseable {
    final Publisher<?>[] ignore;
    final Mono<T> last;

    MonoThenIgnore(Publisher<?>[] ignore, Mono<T> last) {
        this.ignore = Objects.requireNonNull(ignore, "ignore");
        this.last = Objects.requireNonNull(last, "last");
    }

    public void subscribe(Subscriber<? super T> s) {
        ThenIgnoreMain<T> manager = new ThenIgnoreMain<T>(s, this.ignore, this.last);
        s.onSubscribe(manager);
        manager.drain();
    }

    <U> MonoThenIgnore<U> shift(Mono<U> newLast) {
        Objects.requireNonNull(newLast, "newLast");
        Publisher<?>[] a = this.ignore;
        int n = a.length;
        Mono[] b = new Mono[n + 1];
        System.arraycopy(a, 0, b, 0, n);
        b[n] = this.last;
        return new MonoThenIgnore<U>(b, newLast);
    }

    static final class ThenAcceptInner<T>
    implements InnerConsumer<T> {
        final ThenIgnoreMain<T> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ThenAcceptInner, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ThenAcceptInner.class, Subscription.class, "s");
        boolean done;

        ThenAcceptInner(ThenIgnoreMain<T> parent) {
            this.parent = parent;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case ACTUAL: {
                    return this.parent;
                }
                case TERMINATED: {
                    return this.done;
                }
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            this.done = true;
            this.parent.complete(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.parent.onComplete();
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class ThenIgnoreInner
    implements InnerConsumer<Object> {
        final ThenIgnoreMain<?> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ThenIgnoreInner, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ThenIgnoreInner.class, Subscription.class, "s");

        ThenIgnoreInner(ThenIgnoreMain<?> parent) {
            this.parent = parent;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case ACTUAL: {
                    return this.parent;
                }
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.replace(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(Object t) {
        }

        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        public void onComplete() {
            this.parent.ignoreDone();
        }

        void cancel() {
            Operators.terminate(S, this);
        }

        void clear() {
            S.lazySet(this, null);
        }
    }

    static final class ThenIgnoreMain<T>
    extends Operators.MonoSubscriber<T, T> {
        final ThenIgnoreInner ignore;
        final ThenAcceptInner<T> accept;
        final Publisher<?>[] ignoreMonos;
        final Mono<T> lastMono;
        int index;
        volatile boolean active;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ThenIgnoreMain> WIP = AtomicIntegerFieldUpdater.newUpdater(ThenIgnoreMain.class, "wip");

        ThenIgnoreMain(Subscriber<? super T> subscriber, Publisher<?>[] ignoreMonos, Mono<T> lastMono) {
            super(subscriber);
            this.ignoreMonos = ignoreMonos;
            this.lastMono = lastMono;
            this.ignore = new ThenIgnoreInner(this);
            this.accept = new ThenAcceptInner(this);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.ignore, this.accept);
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            while (true) {
                if (this.isCancelled()) {
                    return;
                }
                if (!this.active) {
                    Publisher<?> m;
                    int i = this.index;
                    Publisher<?>[] a = this.ignoreMonos;
                    if (i == a.length) {
                        this.ignore.clear();
                        m = this.lastMono;
                        if (m instanceof Callable) {
                            Object v;
                            try {
                                v = ((Callable)m).call();
                            }
                            catch (Throwable ex) {
                                this.actual.onError(Operators.onOperatorError(ex));
                                return;
                            }
                            if (v == null) {
                                this.actual.onComplete();
                            } else {
                                this.complete(v);
                            }
                            return;
                        }
                        this.active = true;
                        m.subscribe(this.accept);
                    } else {
                        m = a[i];
                        this.index = i + 1;
                        if (m instanceof Callable) {
                            try {
                                ((Callable)m).call();
                            }
                            catch (Throwable ex) {
                                this.actual.onError(Operators.onOperatorError(ex));
                                return;
                            }
                        }
                        this.active = true;
                        m.subscribe((Subscriber)this.ignore);
                    }
                }
                if (WIP.decrementAndGet(this) == 0) break;
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.ignore.cancel();
            this.accept.cancel();
        }

        void ignoreDone() {
            this.active = false;
            this.drain();
        }
    }
}

