/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.AssemblyOp;
import reactor.core.publisher.FluxOnAssembly;
import reactor.core.publisher.ParallelFlux;

final class ParallelFluxOnAssembly<T>
extends ParallelFlux<T>
implements Fuseable,
AssemblyOp,
Scannable {
    final ParallelFlux<T> source;
    final FluxOnAssembly.AssemblySnapshotException stacktrace;

    ParallelFluxOnAssembly(ParallelFlux<T> source) {
        this.source = source;
        this.stacktrace = new FluxOnAssembly.AssemblySnapshotException();
    }

    ParallelFluxOnAssembly(ParallelFlux<T> source, String description) {
        this.source = source;
        this.stacktrace = new FluxOnAssembly.AssemblySnapshotException(description);
    }

    @Override
    public long getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> s = subscribers[i];
            if (s instanceof Fuseable.ConditionalSubscriber) {
                Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
                s = new FluxOnAssembly.OnAssemblyConditionalSubscriber<T>(cs, this.stacktrace, (Publisher<?>)this.source);
            } else {
                s = new FluxOnAssembly.OnAssemblySubscriber<T>(s, this.stacktrace, this.source);
            }
            parents[i] = s;
        }
        this.source.subscribe(parents);
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.source;
            }
            case PREFETCH: {
                return this.getPrefetch();
            }
        }
        return null;
    }
}

