/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;

final class ParallelReduceSeed<T, R>
extends ParallelFlux<R>
implements Scannable,
Fuseable {
    final ParallelFlux<? extends T> source;
    final Supplier<R> initialSupplier;
    final BiFunction<R, ? super T, R> reducer;

    ParallelReduceSeed(ParallelFlux<? extends T> source, Supplier<R> initialSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.reducer = reducer;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.source;
            }
            case PREFETCH: {
                return this.getPrefetch();
            }
        }
        return null;
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            R initialValue;
            try {
                initialValue = Objects.requireNonNull(this.initialSupplier.get(), "The initialSupplier returned a null value");
            }
            catch (Throwable ex) {
                this.reportError(subscribers, Operators.onOperatorError(ex));
                return;
            }
            parents[i] = new ParallelReduceSeedSubscriber<T, R>(subscribers[i], initialValue, this.reducer);
        }
        this.source.subscribe(parents);
    }

    void reportError(Subscriber<?>[] subscribers, Throwable ex) {
        for (Subscriber<?> s : subscribers) {
            Operators.error(s, ex);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelReduceSeedSubscriber<T, R>
    extends Operators.MonoSubscriber<T, R> {
        final BiFunction<R, ? super T, R> reducer;
        R accumulator;
        Subscription s;
        boolean done;

        ParallelReduceSeedSubscriber(Subscriber<? super R> subscriber, R initialValue, BiFunction<R, ? super T, R> reducer) {
            super(subscriber);
            this.accumulator = initialValue;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            R v;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                v = Objects.requireNonNull(this.reducer.apply(this.accumulator, t), "The reducer returned a null value");
            }
            catch (Throwable ex) {
                this.onError(Operators.onOperatorError(this, ex, t));
                return;
            }
            this.accumulator = v;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.accumulator = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            R a = this.accumulator;
            this.accumulator = null;
            this.complete(a);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

