/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.ImmutableSignal;
import reactor.core.publisher.SignalType;

public abstract class Signal<T>
implements Supplier<T>,
Consumer<Subscriber<? super T>> {
    private static final Signal<Void> ON_COMPLETE = new ImmutableSignal<Object>(SignalType.ON_COMPLETE, null, null, null);

    public static <T> Signal<T> complete() {
        return ON_COMPLETE;
    }

    public static <T> Signal<T> error(Throwable e) {
        return new ImmutableSignal<Object>(SignalType.ON_ERROR, null, e, null);
    }

    public static <T> Signal<T> next(T t) {
        return new ImmutableSignal<T>(SignalType.ON_NEXT, t, null, null);
    }

    public static boolean isComplete(Object o) {
        return o == ON_COMPLETE;
    }

    public static boolean isError(Object o) {
        return o instanceof Signal && ((Signal)o).getType() == SignalType.ON_ERROR;
    }

    public static <T> Signal<T> subscribe(Subscription subscription) {
        return new ImmutableSignal<Object>(SignalType.ON_SUBSCRIBE, null, null, subscription);
    }

    public abstract Throwable getThrowable();

    public abstract Subscription getSubscription();

    @Override
    public abstract T get();

    public boolean hasValue() {
        return this.isOnNext() && this.get() != null;
    }

    public boolean hasError() {
        return this.isOnError() && this.getThrowable() != null;
    }

    public abstract SignalType getType();

    public boolean isOnError() {
        return this.getType() == SignalType.ON_ERROR;
    }

    public boolean isOnComplete() {
        return this.getType() == SignalType.ON_COMPLETE;
    }

    public boolean isOnSubscribe() {
        return this.getType() == SignalType.ON_SUBSCRIBE;
    }

    public boolean isOnNext() {
        return this.getType() == SignalType.ON_NEXT;
    }

    @Override
    public void accept(Subscriber<? super T> observer) {
        if (this.isOnNext()) {
            observer.onNext(this.get());
        } else if (this.isOnComplete()) {
            observer.onComplete();
        } else if (this.isOnError()) {
            observer.onError(this.getThrowable());
        } else if (this.isOnSubscribe()) {
            observer.onSubscribe(this.getSubscription());
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Signal)) {
            return false;
        }
        Signal signal = (Signal)o;
        if (this.getType() != signal.getType()) {
            return false;
        }
        if (this.isOnComplete()) {
            return true;
        }
        if (this.isOnSubscribe()) {
            return Objects.equals(this.getSubscription(), signal.getSubscription());
        }
        if (this.isOnError()) {
            return Objects.equals(this.getThrowable(), signal.getThrowable());
        }
        if (this.isOnNext()) {
            return Objects.equals(this.get(), signal.get());
        }
        return false;
    }

    public final int hashCode() {
        int result;
        int n = result = this.getType() != null ? this.getType().hashCode() : 0;
        if (this.isOnError()) {
            return 31 * result + (this.getThrowable() != null ? this.getThrowable().hashCode() : 0);
        }
        if (this.isOnNext()) {
            return 31 * result + (this.get() != null ? this.get().hashCode() : 0);
        }
        if (this.isOnSubscribe()) {
            return 31 * result + (this.getSubscription() != null ? this.getSubscription().hashCode() : 0);
        }
        return result;
    }

    public String toString() {
        switch (this.getType()) {
            case ON_SUBSCRIBE: {
                return String.format("onSubscribe(%s)", this.getSubscription());
            }
            case ON_NEXT: {
                return String.format("onNext(%s)", this.get());
            }
            case ON_ERROR: {
                return String.format("onError(%s)", this.getThrowable());
            }
            case ON_COMPLETE: {
                return "onComplete()";
            }
        }
        return String.format("Signal type=%s", new Object[]{this.getType()});
    }
}

