/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.Disposable;
import reactor.core.scheduler.DisposableContainer;
import reactor.core.scheduler.EmptyDisposableContainer;
import reactor.core.scheduler.ExecutorServiceScheduler;
import reactor.core.scheduler.Schedulers;

final class ScheduledRunnable
implements Runnable,
Disposable {
    private static final DisposableContainer<ScheduledRunnable> DISPOSED_PARENT = new EmptyDisposableContainer<ScheduledRunnable>();
    private static final DisposableContainer<ScheduledRunnable> DONE_PARENT = new EmptyDisposableContainer<ScheduledRunnable>();
    final Runnable task;
    volatile Future<?> future;
    static final AtomicReferenceFieldUpdater<ScheduledRunnable, Future> FUTURE = AtomicReferenceFieldUpdater.newUpdater(ScheduledRunnable.class, Future.class, "future");
    volatile DisposableContainer<ScheduledRunnable> parent;
    static final AtomicReferenceFieldUpdater<ScheduledRunnable, DisposableContainer> PARENT = AtomicReferenceFieldUpdater.newUpdater(ScheduledRunnable.class, DisposableContainer.class, "parent");

    ScheduledRunnable(Runnable task, DisposableContainer<ScheduledRunnable> parent) {
        this.task = task;
        PARENT.lazySet(this, parent);
    }

    @Override
    public void run() {
        try {
            try {
                this.task.run();
            }
            catch (Throwable ex) {
                Schedulers.handleError(ex);
            }
        }
        finally {
            Future<?> f;
            DisposableContainer<ScheduledRunnable> o = this.parent;
            if (o != DISPOSED_PARENT && o != null && PARENT.compareAndSet(this, o, DONE_PARENT)) {
                o.remove(this);
            }
            while ((f = this.future) != ExecutorServiceScheduler.CANCELLED && !FUTURE.compareAndSet(this, f, ExecutorServiceScheduler.FINISHED)) {
            }
        }
    }

    void setFuture(Future<?> f) {
        Future<?> o;
        do {
            if ((o = this.future) == ExecutorServiceScheduler.FINISHED) {
                return;
            }
            if (o != ExecutorServiceScheduler.CANCELLED) continue;
            f.cancel(true);
            return;
        } while (!FUTURE.compareAndSet(this, o, f));
    }

    @Override
    public boolean isDisposed() {
        Future<?> a = this.future;
        return ExecutorServiceScheduler.FINISHED == a || ExecutorServiceScheduler.CANCELLED == a;
    }

    @Override
    public void dispose() {
        DisposableContainer<ScheduledRunnable> o;
        Future<?> f;
        while ((f = this.future) != ExecutorServiceScheduler.FINISHED && f != ExecutorServiceScheduler.CANCELLED) {
            if (!FUTURE.compareAndSet(this, f, ExecutorServiceScheduler.CANCELLED)) continue;
            if (f == null) break;
            f.cancel(true);
            break;
        }
        do {
            if ((o = this.parent) != DONE_PARENT && o != DISPOSED_PARENT && o != null) continue;
            return;
        } while (!PARENT.compareAndSet(this, o, DISPOSED_PARENT));
        o.remove(this);
    }
}

