/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MuleException
extends Exception {
    public static final String INFO_LOCATION_KEY = "Element";
    public static final String INFO_SOURCE_XML_KEY = "Element XML";
    private static final long serialVersionUID = -4544199933449632546L;
    private static final Logger logger = LoggerFactory.getLogger(MuleException.class);
    private static final String EXCEPTION_MESSAGE_DELIMITER = MuleException.repeat('*', 80) + SystemUtils.LINE_SEPARATOR;
    private static final String EXCEPTION_MESSAGE_SECTION_DELIMITER = MuleException.repeat('-', 80) + SystemUtils.LINE_SEPARATOR;
    public static boolean verboseExceptions = false;
    private final Map info = new HashMap();
    private int errorCode = -1;
    private String message = null;
    private I18nMessage i18nMessage;

    public MuleException(I18nMessage message) {
        this.setMessage(message);
    }

    public MuleException(I18nMessage message, Throwable cause) {
        super(ExceptionHelper.unwrap(cause));
        this.setMessage(message);
    }

    public MuleException(Throwable cause) {
        super(ExceptionHelper.unwrap(cause));
        if (cause != null) {
            this.setMessage(I18nMessageFactory.createStaticMessage(cause.getMessage() + " (" + cause.getClass().getName() + ")"));
        } else {
            this.initialise();
        }
    }

    private static String repeat(char c, int len) {
        String str = String.valueOf(c);
        if (str == null) {
            return null;
        }
        if (len <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    protected MuleException() {
        this.initialise();
    }

    protected void setMessage(I18nMessage message) {
        this.initialise();
        this.message = message.getMessage();
        this.i18nMessage = message;
    }

    protected void setMessage(String message) {
        this.initialise();
        this.message = message;
        if (this.i18nMessage == null) {
            this.i18nMessage = I18nMessageFactory.createStaticMessage(message);
        }
    }

    public int getExceptionCode() {
        return this.errorCode;
    }

    public I18nMessage getI18nMessage() {
        return this.i18nMessage;
    }

    public int getMessageCode() {
        return this.i18nMessage == null ? 0 : this.i18nMessage.getCode();
    }

    public void addInfo(String name, Object info) {
        this.info.put(name, info);
    }

    protected void appendMessage(String s) {
        this.message = this.message + s;
    }

    protected void prependMessage(String s) {
        this.message = this.message + ". " + s;
    }

    protected void setExceptionCode(int code) {
        this.errorCode = code;
    }

    @Override
    public final String getMessage() {
        return this.message;
    }

    protected void initialise() {
        this.setExceptionCode(-1);
    }

    public String getDetailedMessage() {
        if (MuleException.isVerboseExceptions()) {
            return this.getVerboseMessage();
        }
        return this.getSummaryMessage();
    }

    public String getVerboseMessage() {
        MuleException e = ExceptionHelper.getRootMuleException(this);
        if (!e.equals(this)) {
            return this.getMessage();
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append(SystemUtils.LINE_SEPARATOR).append(EXCEPTION_MESSAGE_DELIMITER);
        buf.append("Message               : ").append(this.message).append(SystemUtils.LINE_SEPARATOR);
        Map info = ExceptionHelper.getExceptionInfo(this);
        for (Map.Entry entry : info.entrySet()) {
            String s = (String)entry.getKey();
            int pad = 22 - s.length();
            buf.append(s);
            if (pad > 0) {
                buf.append(MuleException.repeat(' ', pad));
            }
            buf.append(": ");
            buf.append(entry.getValue() == null ? "null" : entry.getValue().toString().replaceAll(SystemUtils.LINE_SEPARATOR, SystemUtils.LINE_SEPARATOR + MuleException.repeat(' ', 24))).append(SystemUtils.LINE_SEPARATOR);
        }
        buf.append(EXCEPTION_MESSAGE_SECTION_DELIMITER);
        buf.append("Root Exception stack trace:").append(SystemUtils.LINE_SEPARATOR);
        Throwable root = ExceptionHelper.getRootException(this);
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        root.printStackTrace(p);
        buf.append(w.toString()).append(SystemUtils.LINE_SEPARATOR);
        buf.append(EXCEPTION_MESSAGE_DELIMITER);
        return buf.toString();
    }

    public String getSummaryMessage() {
        MuleException e = ExceptionHelper.getRootMuleException(this);
        if (!e.equals(this)) {
            return this.getMessage();
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append(SystemUtils.LINE_SEPARATOR).append(EXCEPTION_MESSAGE_DELIMITER);
        buf.append("Message               : ").append(this.message).append(SystemUtils.LINE_SEPARATOR);
        this.appendSummaryMessage(buf);
        buf.append(SystemUtils.LINE_SEPARATOR).append("  (set debug level logging or '-Dmule.verbose.exceptions=true' for everything)").append(SystemUtils.LINE_SEPARATOR);
        buf.append(EXCEPTION_MESSAGE_DELIMITER);
        return buf.toString();
    }

    protected void appendSummaryMessage(StringBuilder builder) {
        Map exceptionInfo = ExceptionHelper.getExceptionInfo(this);
        builder.append("Element               : ").append(exceptionInfo.get(INFO_LOCATION_KEY)).append(SystemUtils.LINE_SEPARATOR);
        Object sourceXml = exceptionInfo.get(INFO_SOURCE_XML_KEY);
        if (sourceXml != null) {
            builder.append("Element XML           : ").append(sourceXml).append(SystemUtils.LINE_SEPARATOR);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleException)) {
            return false;
        }
        MuleException exception = (MuleException)o;
        if (this.errorCode != exception.errorCode) {
            return false;
        }
        if (this.i18nMessage != null ? !this.i18nMessage.equals(exception.i18nMessage) : exception.i18nMessage != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(exception.message) : exception.message != null);
    }

    public int hashCode() {
        int result = this.errorCode;
        result = 29 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 29 * result + (this.i18nMessage != null ? this.i18nMessage.hashCode() : 0);
        return result;
    }

    public Map getInfo() {
        return this.info;
    }

    public static boolean isVerboseExceptions() {
        return verboseExceptions || logger.isDebugEnabled();
    }

    static {
        String p = System.getProperty("mule.verbose.exceptions");
        if (p != null) {
            verboseExceptions = Boolean.parseBoolean(p);
        }
    }
}

