/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.agent;

import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.agent.AbstractAgent;
import org.mule.runtime.core.api.context.notification.ConnectionNotificationListener;
import org.mule.runtime.core.api.context.notification.CustomNotificationListener;
import org.mule.runtime.core.api.context.notification.ManagementNotificationListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.SecurityNotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.context.notification.ConnectionNotification;
import org.mule.runtime.core.context.notification.ManagementNotification;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.context.notification.NotificationException;
import org.mule.runtime.core.context.notification.SecurityNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNotificationLoggerAgent
extends AbstractAgent {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean ignoreManagerNotifications = false;
    private boolean ignoreConnectionNotifications = false;
    private boolean ignoreSecurityNotifications = false;
    private boolean ignoreManagementNotifications = false;
    private boolean ignoreCustomNotifications = false;
    private boolean ignoreAdminNotifications = false;
    private boolean ignoreMessageNotifications = false;
    private boolean ignoreComponentMessageNotifications = false;
    private boolean ignoreMessageProcessorNotifications = true;
    protected Set<ServerNotificationListener<? extends ServerNotification>> listeners = new HashSet<ServerNotificationListener<? extends ServerNotification>>();

    protected AbstractNotificationLoggerAgent(String name) {
        super(name);
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
        for (ServerNotificationListener<? extends ServerNotification> listener : this.listeners) {
            this.muleContext.unregisterListener(listener);
        }
    }

    public boolean isIgnoreManagerNotifications() {
        return this.ignoreManagerNotifications;
    }

    public void setIgnoreManagerNotifications(boolean ignoreManagerNotifications) {
        this.ignoreManagerNotifications = ignoreManagerNotifications;
    }

    public boolean isIgnoreMessageNotifications() {
        return this.ignoreMessageNotifications;
    }

    public void setIgnoreMessageNotifications(boolean ignoreMessageNotifications) {
        this.ignoreMessageNotifications = ignoreMessageNotifications;
    }

    public boolean isIgnoreSecurityNotifications() {
        return this.ignoreSecurityNotifications;
    }

    public void setIgnoreSecurityNotifications(boolean ignoreSecurityNotifications) {
        this.ignoreSecurityNotifications = ignoreSecurityNotifications;
    }

    public boolean isIgnoreManagementNotifications() {
        return this.ignoreManagementNotifications;
    }

    public void setIgnoreManagementNotifications(boolean ignoreManagementNotifications) {
        this.ignoreManagementNotifications = ignoreManagementNotifications;
    }

    public boolean isIgnoreCustomNotifications() {
        return this.ignoreCustomNotifications;
    }

    public void setIgnoreCustomNotifications(boolean ignoreCustomNotifications) {
        this.ignoreCustomNotifications = ignoreCustomNotifications;
    }

    public boolean isIgnoreAdminNotifications() {
        return this.ignoreAdminNotifications;
    }

    public void setIgnoreAdminNotifications(boolean ignoreAdminNotifications) {
        this.ignoreAdminNotifications = ignoreAdminNotifications;
    }

    public boolean isIgnoreConnectionNotifications() {
        return this.ignoreConnectionNotifications;
    }

    public void setIgnoreConnectionNotifications(boolean ignoreConnectionNotifications) {
        this.ignoreConnectionNotifications = ignoreConnectionNotifications;
    }

    public boolean isIgnoreComponentMessageNotifications() {
        return this.ignoreComponentMessageNotifications;
    }

    public void setIgnoreComponentMessageNotifications(boolean ignoreComponentMessageNotifications) {
        this.ignoreComponentMessageNotifications = ignoreComponentMessageNotifications;
    }

    public boolean isIgnoreMessageProcessorNotifications() {
        return this.ignoreMessageProcessorNotifications;
    }

    public void setIgnoreMessageProcessorNotifications(boolean ignoreMessageProcessorNotifications) {
        this.ignoreMessageProcessorNotifications = ignoreMessageProcessorNotifications;
    }

    public final void initialise() throws InitialisationException {
        ServerNotificationListener<MuleContextNotification> l;
        this.doInitialise();
        if (!this.ignoreManagerNotifications) {
            l = new MuleContextNotificationListener<MuleContextNotification>(){

                @Override
                public void onNotification(MuleContextNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                this.muleContext.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
            }
            this.listeners.add((ServerNotificationListener<? extends ServerNotification>)l);
        }
        if (!this.ignoreSecurityNotifications) {
            l = new SecurityNotificationListener<SecurityNotification>(){

                @Override
                public void onNotification(SecurityNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                this.muleContext.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
            }
            this.listeners.add((ServerNotificationListener<? extends ServerNotification>)l);
        }
        if (!this.ignoreManagementNotifications) {
            l = new ManagementNotificationListener<ManagementNotification>(){

                @Override
                public void onNotification(ManagementNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                this.muleContext.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
            }
            this.listeners.add((ServerNotificationListener<? extends ServerNotification>)l);
        }
        if (!this.ignoreCustomNotifications) {
            l = new CustomNotificationListener<ServerNotification>(){

                @Override
                public void onNotification(ServerNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                this.muleContext.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
            }
            this.listeners.add((ServerNotificationListener<? extends ServerNotification>)l);
        }
        if (!this.ignoreConnectionNotifications) {
            l = new ConnectionNotificationListener<ConnectionNotification>(){

                @Override
                public void onNotification(ConnectionNotification notification) {
                    AbstractNotificationLoggerAgent.this.logEvent(notification);
                }
            };
            try {
                this.muleContext.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
            }
            this.listeners.add((ServerNotificationListener<? extends ServerNotification>)l);
        }
        if (!this.ignoreMessageNotifications && !this.ignoreComponentMessageNotifications) {
            l = notification -> this.logEvent(notification);
            try {
                this.muleContext.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
            }
            this.listeners.add((ServerNotificationListener<? extends ServerNotification>)l);
        }
        if (!this.ignoreMessageNotifications && !this.ignoreMessageProcessorNotifications) {
            l = notification -> this.logEvent(notification);
            try {
                this.muleContext.registerListener(l);
            }
            catch (NotificationException e) {
                throw new InitialisationException((Throwable)((Object)e), (Initialisable)this);
            }
            this.listeners.add((ServerNotificationListener<? extends ServerNotification>)l);
        }
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void logEvent(ServerNotification var1);
}

