/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.model.resolvers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.model.EntryPointResolver;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.internal.VoidResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntryPointResolver
implements EntryPointResolver {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEntryPointResolver.class);
    private boolean acceptVoidMethods = false;
    private boolean synchronizeCall = false;
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Method>> methodCache = new ConcurrentHashMap(4);

    public boolean isAcceptVoidMethods() {
        return this.acceptVoidMethods;
    }

    public void setAcceptVoidMethods(boolean acceptVoidMethods) {
        this.acceptVoidMethods = acceptVoidMethods;
    }

    protected ConcurrentHashMap<String, Method> getMethodCache(Object component) {
        Class<?> componentClass = component.getClass();
        ConcurrentHashMap<String, Method> cache = this.methodCache.get(componentClass);
        if (cache == null) {
            this.methodCache.putIfAbsent(componentClass, new ConcurrentHashMap(4));
        }
        return this.methodCache.get(componentClass);
    }

    protected Method getMethodByName(Object component, String methodName, MuleEventContext context) {
        return this.getMethodCache(component).get(methodName);
    }

    protected Method addMethodByName(Object component, Method method, MuleEventContext context) {
        Method previousMethod = this.getMethodCache(component).putIfAbsent(method.getName(), method);
        return previousMethod != null ? previousMethod : method;
    }

    protected Method addMethodByArguments(Object component, Method method, Object[] payload) {
        Method previousMethod = this.getMethodCache(component).putIfAbsent(this.getCacheKeyForPayload(component, payload), method);
        return previousMethod != null ? previousMethod : method;
    }

    protected Method getMethodByArguments(Object component, Object[] payload) {
        Method method = this.getMethodCache(component).get(this.getCacheKeyForPayload(component, payload));
        return method;
    }

    protected String getCacheKeyForPayload(Object component, Object[] payload) {
        StringBuilder key = new StringBuilder(48);
        for (Object o : payload) {
            if (o != null) {
                key.append(o.getClass().getName());
                continue;
            }
            key.append("null");
        }
        key.append(".").append(ClassUtils.getClassName(component.getClass()));
        return key.toString();
    }

    protected Object[] getPayloadFromMessage(MuleEventContext context) throws TransformerException {
        Object temp = context.getMessage().getPayload().getValue();
        if (temp instanceof Object[]) {
            return (Object[])temp;
        }
        if (temp == null) {
            return ClassUtils.NO_ARGS;
        }
        return new Object[]{temp};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InvocationResult invokeMethod(Object component, Method method, Object[] arguments) throws InvocationTargetException, IllegalAccessException {
        Object result;
        String methodCall = null;
        if (logger.isDebugEnabled()) {
            methodCall = component.getClass().getName() + "." + method.getName() + "(" + StringMessageUtils.toString(ClassUtils.getClassTypes(arguments)) + ")";
            logger.debug("Invoking " + methodCall);
        }
        if (this.isSynchronizeCall()) {
            Object object = component;
            synchronized (object) {
                result = method.invoke(component, arguments);
            }
        } else {
            result = method.invoke(component, arguments);
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            result = VoidResult.getInstance();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Result of call " + methodCall + " is " + (result == null ? "null" : "not null"));
        }
        return new InvocationResult(this, result, method);
    }

    public boolean isSynchronizeCall() {
        return this.synchronizeCall;
    }

    public void setSynchronizeCall(boolean synchronizeCall) {
        this.synchronizeCall = synchronizeCall;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AbstractEntryPointResolver");
        sb.append(", acceptVoidMethods=").append(this.acceptVoidMethods);
        sb.append('}');
        return sb.toString();
    }
}

