/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.context.notification;

import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;

public class OptimisedNotificationHandler
implements ServerNotificationHandler {
    private ServerNotificationHandler delegate;
    private Class<? extends ServerNotification> type;
    private boolean dynamic = false;
    private volatile Boolean enabled = null;

    public OptimisedNotificationHandler(ServerNotificationHandler delegate, Class<? extends ServerNotification> type) {
        this.delegate = delegate;
        this.type = type;
        this.dynamic = delegate.isNotificationDynamic();
    }

    @Override
    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    @Override
    public boolean isListenerRegistered(ServerNotificationListener listener) {
        return this.delegate.isListenerRegistered(listener);
    }

    @Override
    public boolean isNotificationEnabled(Class<? extends ServerNotification> notfnClass) {
        if (!this.dynamic && this.type.isAssignableFrom(notfnClass)) {
            if (this.enabled == null) {
                this.enabled = this.delegate.isNotificationEnabled(notfnClass);
            }
            return this.enabled;
        }
        return this.delegate.isNotificationEnabled(notfnClass);
    }

    @Override
    public void fireNotification(ServerNotification notification) {
        if (this.isNotificationEnabled(notification.getClass())) {
            this.delegate.fireNotification(notification);
        }
    }
}

