/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.ExecutionContext;
import org.mule.runtime.core.execution.ExecutionInterceptor;

class HandleExceptionInterceptor
implements ExecutionInterceptor<Event> {
    private final ExecutionInterceptor<Event> next;
    private final MessagingExceptionHandler messagingExceptionHandler;
    private final FlowConstruct flow;

    public HandleExceptionInterceptor(ExecutionInterceptor<Event> next, MessagingExceptionHandler messagingExceptionHandler, FlowConstruct flow) {
        this.next = next;
        this.messagingExceptionHandler = messagingExceptionHandler;
        this.flow = flow;
    }

    @Override
    public Event execute(ExecutionCallback<Event> callback, ExecutionContext executionContext) throws Exception {
        try {
            return this.next.execute(callback, executionContext);
        }
        catch (MessagingException e) {
            try {
                Event result = this.messagingExceptionHandler != null ? this.messagingExceptionHandler.handleException(e, e.getEvent()) : this.flow.getExceptionListener().handleException(e, e.getEvent());
                e.setProcessedEvent(result);
            }
            catch (Exception messagingExceptionHandlerException) {
                if (messagingExceptionHandlerException.getCause() instanceof MessagingException) {
                    throw (MessagingException)((Object)messagingExceptionHandlerException.getCause());
                }
                throw messagingExceptionHandlerException;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }
}

