/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.PolicyEventConverter;
import org.mule.runtime.core.policy.PolicyStateHandler;
import org.mule.runtime.core.policy.PolicyStateId;

public class SourcePolicyProcessor
implements Processor {
    private final Policy policy;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();
    private final Processor nextProcessor;

    public SourcePolicyProcessor(Policy policy, PolicyStateHandler policyStateHandler, Processor nextProcessor) {
        this.policy = policy;
        this.policyStateHandler = policyStateHandler;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public Event process(Event sourceEvent) throws MuleException {
        String executionIdentifier = sourceEvent.getContext().getId();
        this.policyStateHandler.updateNextOperation(executionIdentifier, nextProcessorEvent -> {
            this.policyStateHandler.updateState(new PolicyStateId(executionIdentifier, this.policy.getPolicyId()), nextProcessorEvent);
            Event nextProcessorResult = this.nextProcessor.process(this.policyEventConverter.createEvent(nextProcessorEvent, sourceEvent));
            return this.policyEventConverter.createEvent(nextProcessorResult, nextProcessorEvent);
        });
        Event sourcePolicyResult = this.policy.getPolicyChain().process(this.policyEventConverter.createEvent(sourceEvent, Event.builder(sourceEvent.getContext()).message(Message.of(null)).build()));
        return this.policyEventConverter.createEvent(sourcePolicyResult, sourceEvent);
    }
}

