/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.Base64;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class Base64Encoder
extends AbstractTransformer {
    public Base64Encoder() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.setReturnDataType(DataType.STRING);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        try {
            byte[] buf = src instanceof String ? ((String)src).getBytes(encoding) : (src instanceof CursorStreamProvider ? this.handleStream((InputStream)((CursorStreamProvider)src).openCursor(), encoding) : (src instanceof InputStream ? this.handleStream((InputStream)src, encoding) : (byte[])src));
            String result = Base64.encodeBytes(buf, 8);
            if (byte[].class.isAssignableFrom(this.getReturnDataType().getType())) {
                return result.getBytes(encoding);
            }
            return result;
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed(src.getClass().getName(), "base64"), this, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] handleStream(InputStream src, Charset encoding) throws IOException {
        try (InputStreamReader input = new InputStreamReader(src);){
            byte[] byArray = IOUtils.toByteArray((Reader)input, (Charset)encoding);
            return byArray;
        }
    }
}

