/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.lifecycle;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.notification.ClusterNodeNotification;
import org.mule.runtime.api.notification.ClusterNodeNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleStateEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryNodeLifecycleNotificationListener
implements ClusterNodeNotificationListener {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Startable startMeOnPrimaryNodeNotification;
    private NotificationListenerRegistry notificationListenerRegistry;

    public PrimaryNodeLifecycleNotificationListener(Startable startMeOnPrimaryNodeNotification, NotificationListenerRegistry notificationListenerRegistry) {
        this.startMeOnPrimaryNodeNotification = startMeOnPrimaryNodeNotification;
        this.notificationListenerRegistry = notificationListenerRegistry;
    }

    public void register() {
        if (this.notificationListenerRegistry != null) {
            this.notificationListenerRegistry.registerListener((NotificationListener)this);
        }
    }

    public void onNotification(ClusterNodeNotification notification) {
        try {
            if (this.startMeOnPrimaryNodeNotification instanceof LifecycleState) {
                if (((LifecycleState)this.startMeOnPrimaryNodeNotification).isStarted()) {
                    this.startMeOnPrimaryNodeNotification.start();
                } else {
                    this.logStartableNotStartedMessage();
                }
            } else if (this.startMeOnPrimaryNodeNotification instanceof LifecycleStateEnabled) {
                if (((LifecycleStateEnabled)this.startMeOnPrimaryNodeNotification).getLifecycleState().isStarted()) {
                    this.startMeOnPrimaryNodeNotification.start();
                } else {
                    this.logStartableNotStartedMessage();
                }
            } else {
                this.startMeOnPrimaryNodeNotification.start();
            }
        }
        catch (MuleException e) {
            throw new RuntimeException("Error starting wrapped message source", e);
        }
    }

    private void logStartableNotStartedMessage() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Not starting Startable since it's not in started state");
        }
    }

    public void unregister() {
        this.notificationListenerRegistry.unregisterListener((NotificationListener)this);
    }
}

