/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.AbstractFlowConstruct;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.IdempotentRedeliveryPolicy;
import org.mule.runtime.core.privileged.processor.InternalProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractPipeline
extends AbstractFlowConstruct
implements Pipeline {
    private final MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(this);
    private final NotificationDispatcher notificationFirer;
    private final MessageSource source;
    private final List<Processor> processors;
    private MessageProcessorChain pipeline;
    private static String OVERLOAD_ERROR_MESSAGE = "Flow '%s' is unable to accept new events at this time";
    private final ErrorType overloadErrorType;
    private final ProcessingStrategy processingStrategy;
    private volatile boolean canProcessMessage = false;
    private Sink sink;
    private final int maxConcurrency;

    public AbstractPipeline(String name, MuleContext muleContext, MessageSource source, List<Processor> processors, Optional<FlowExceptionHandler> exceptionListener, Optional<ProcessingStrategyFactory> processingStrategyFactory, String initialState, int maxConcurrency, FlowConstructStatistics flowConstructStatistics) {
        super(name, muleContext, exceptionListener, initialState, flowConstructStatistics);
        try {
            this.notificationFirer = ((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(NotificationDispatcher.class);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)((Object)e));
        }
        this.source = source;
        this.processors = Collections.unmodifiableList(processors);
        this.maxConcurrency = maxConcurrency;
        ProcessingStrategyFactory psFactory = processingStrategyFactory.orElseGet(() -> this.defaultProcessingStrategy());
        if (psFactory instanceof AsyncProcessingStrategyFactory) {
            ((AsyncProcessingStrategyFactory)psFactory).setMaxConcurrency(maxConcurrency);
        }
        this.processingStrategy = psFactory.create(muleContext, this.getName());
        this.overloadErrorType = muleContext.getErrorTypeRepository().getErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD).orElse(null);
    }

    protected MessageProcessorChain createPipeline() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'" + this.getName() + "' processor chain");
        if (this.processingStrategy != null) {
            builder.setProcessingStrategy(this.processingStrategy);
        }
        this.configurePreProcessors(builder);
        this.configureMessageProcessors(builder);
        this.configurePostProcessors(builder);
        return builder.build();
    }

    protected ProcessingStrategyFactory createDefaultProcessingStrategyFactory() {
        return new DirectProcessingStrategyFactory();
    }

    private ProcessingStrategyFactory defaultProcessingStrategy() {
        ProcessingStrategyFactory defaultProcessingStrategyFactory = this.getMuleContext().getConfiguration().getDefaultProcessingStrategyFactory();
        if (defaultProcessingStrategyFactory == null) {
            return this.createDefaultProcessingStrategyFactory();
        }
        return defaultProcessingStrategyFactory;
    }

    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain(new ProcessorStartCompleteProcessor());
    }

    protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain(new ProcessEndProcessor());
    }

    @Override
    public List<Processor> getProcessors() {
        return this.processors;
    }

    @Override
    public MessageSource getSource() {
        return this.source;
    }

    protected MessageProcessorChain getPipeline() {
        return this.pipeline;
    }

    @Override
    public boolean isSynchronous() {
        return this.processingStrategy.isSynchronous();
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    protected void doInitialise() throws MuleException {
        super.doInitialise();
        this.pipeline = this.createPipeline();
        if (this.source != null) {
            this.source.setListener(new Processor(){

                @Override
                public CoreEvent process(CoreEvent event) throws MuleException {
                    return MessageProcessors.processToApply(event, this);
                }

                @Override
                public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                    return Flux.from(publisher).doOnNext(AbstractPipeline.this.assertStarted()).transform((Function)AbstractPipeline.this.dispatchToFlow(AbstractPipeline.this.sink));
                }
            });
        }
        LifecycleUtils.initialiseIfNeeded(this.source, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.pipeline, this.muleContext);
    }

    private ReactiveProcessor dispatchToFlow(Sink sink) {
        if (this.source.getBackPressureStrategy() == MessageSource.BackPressureStrategy.WAIT) {
            return publisher -> Flux.from((Publisher)publisher).doOnNext(event -> {
                try {
                    sink.accept((CoreEvent)event);
                }
                catch (RejectedExecutionException ree) {
                    MessagingException me = new MessagingException((CoreEvent)event, ree, (Component)this);
                    ((BaseEventContext)event.getContext()).error((Throwable)((Object)this.exceptionResolver.resolve(me, this.getMuleContext())));
                }
            }).flatMap(event -> Mono.from(((BaseEventContext)event.getContext()).getResponsePublisher()));
        }
        return publisher -> Flux.from((Publisher)publisher).flatMap(event -> {
            if (sink.emit((CoreEvent)event)) {
                return ((BaseEventContext)event.getContext()).getResponsePublisher();
            }
            if (this.source.getBackPressureStrategy() == MessageSource.BackPressureStrategy.DROP) {
                return Flux.empty();
            }
            RejectedExecutionException rejectedExecutionException = new RejectedExecutionException(String.format(OVERLOAD_ERROR_MESSAGE, this.getName()));
            return Flux.error((Throwable)((Object)this.exceptionResolver.resolve(new MessagingException(CoreEvent.builder(event).error(ErrorBuilder.builder().errorType(this.overloadErrorType).description(String.format("Flow '%s' Busy.", this.getName())).detailedDescription(String.format(OVERLOAD_ERROR_MESSAGE, this.getName())).exception(rejectedExecutionException).build()).build(), rejectedExecutionException, (Component)this), this.muleContext)));
        });
    }

    protected ReactiveProcessor processFlowFunction() {
        return stream -> Flux.from((Publisher)stream).transform((Function)this.processingStrategy.onPipeline(this.pipeline)).doOnNext(response -> ((BaseEventContext)response.getContext()).success((CoreEvent)response)).doOnError(throwable -> !(throwable instanceof RejectedExecutionException), throwable -> LOGGER.error("Unhandled exception in Flow ", throwable));
    }

    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        for (Processor processor : this.getProcessors()) {
            if (processor instanceof Processor) {
                builder.chain(processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)((Object)processor));
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
    }

    protected boolean isRedeliveryPolicyConfigured() {
        if (this.getProcessors().isEmpty()) {
            return false;
        }
        return this.getProcessors().get(0) instanceof IdempotentRedeliveryPolicy;
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        this.startIfStartable(this.processingStrategy);
        this.sink = this.processingStrategy.createSink(this, this.processFlowFunction());
        try {
            this.startIfStartable(this.pipeline);
        }
        catch (MuleException e) {
            this.doStop();
            throw e;
        }
        this.canProcessMessage = true;
        if (this.getMuleContext().isStarted()) {
            try {
                this.startIfStartable(this.source);
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (MuleException e) {
                this.doStop();
                throw e;
            }
        }
    }

    public Consumer<CoreEvent> assertStarted() {
        return event -> {
            if (!this.canProcessMessage) {
                throw Exceptions.propagate((Throwable)((Object)new MessagingException((CoreEvent)event, new LifecycleException(CoreMessages.isStopped(this.getName()), (Object)event.getMessage()))));
            }
        };
    }

    @Override
    protected void doStop() throws MuleException {
        try {
            this.stopIfStoppable(this.source);
        }
        finally {
            this.canProcessMessage = false;
        }
        this.disposeIfDisposable(this.sink);
        this.sink = null;
        this.stopIfStoppable(this.processingStrategy);
        this.stopIfStoppable(this.pipeline);
        super.doStop();
    }

    @Override
    protected void doDispose() {
        this.disposeIfDisposable(this.pipeline);
        this.disposeIfDisposable(this.source);
        super.doDispose();
    }

    protected Sink getSink() {
        return this.sink;
    }

    @Override
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    private class ProcessorStartCompleteProcessor
    implements Processor,
    InternalProcessor {
        private ProcessorStartCompleteProcessor() {
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            AbstractPipeline.this.notificationFirer.dispatch((Notification)new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, (Component)AbstractPipeline.this), AbstractPipeline.this.getName(), 1801));
            long startTime = System.currentTimeMillis();
            Mono.from(((BaseEventContext)event.getContext()).getBeforeResponsePublisher()).doOnSuccess(result -> this.fireCompleteNotification((CoreEvent)result, null)).doOnError(MessagingException.class, messagingException -> this.fireCompleteNotification(null, (MessagingException)((Object)messagingException))).doOnError(throwable -> !(throwable instanceof MessagingException), throwable -> this.fireCompleteNotification(null, new MessagingException(event, (Throwable)throwable, (Component)AbstractPipeline.this))).doOnSuccessOrError((result, throwable) -> ((BaseEventContext)event.getContext()).getProcessingTime().ifPresent(time -> time.addFlowExecutionBranchTime(startTime))).subscribe(Operators.requestUnbounded());
            return event;
        }

        private void fireCompleteNotification(CoreEvent event, MessagingException messagingException) {
            AbstractPipeline.this.notificationFirer.dispatch((Notification)new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, (Exception)((Object)messagingException), (Component)AbstractPipeline.this), AbstractPipeline.this.getName(), 1804));
        }
    }

    private class ProcessEndProcessor
    extends AbstractComponent
    implements Processor,
    InternalProcessor {
        private ProcessEndProcessor() {
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            AbstractPipeline.this.notificationFirer.dispatch((Notification)new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, (Component)AbstractPipeline.this), AbstractPipeline.this.getName(), 1802));
            return event;
        }
    }
}

