/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class RedeliveryExceeded
extends AbstractComponent
implements Initialisable,
ReactiveProcessor {
    @Inject
    private MuleContext muleContext;
    private List<Processor> messageProcessors = new CopyOnWriteArrayList<Processor>();
    private MessageProcessorChain configuredMessageProcessors;

    public void initialise() throws InitialisationException {
        this.configuredMessageProcessors = MessageProcessors.newChain(MessageProcessors.getProcessingStrategy(this.muleContext, this.getRootContainerName()), this.messageProcessors);
    }

    public List<Processor> getMessageProcessors() {
        return Collections.unmodifiableList(this.messageProcessors);
    }

    public void setMessageProcessors(List<Processor> processors) {
        if (processors == null) {
            throw new IllegalArgumentException("List of targets = null");
        }
        this.messageProcessors.clear();
        this.messageProcessors.addAll(processors);
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        CoreEvent result = event;
        if (!this.messageProcessors.isEmpty()) {
            result = this.configuredMessageProcessors.process(event);
        }
        if (result != null) {
            result = this.removeErrorFromEvent(result);
        }
        return result;
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> eventPublisher) {
        if (!this.messageProcessors.isEmpty()) {
            return Flux.from(eventPublisher).transform((Function)this.configuredMessageProcessors);
        }
        return Flux.from(eventPublisher).map(event -> this.removeErrorFromEvent((CoreEvent)event));
    }

    private CoreEvent removeErrorFromEvent(CoreEvent result) {
        return CoreEvent.builder(result).error(null).message(InternalMessage.builder(result.getMessage()).exceptionPayload(null).build()).build();
    }
}

