/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.internal.lifecycle.EmptyLifecycleCallback;
import org.mule.runtime.core.internal.lifecycle.HasLifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.PhaseErrorLifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.RegistryLifecycleCallback;
import org.mule.runtime.core.internal.lifecycle.phases.LifecyclePhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextDisposePhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextInitialisePhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextStartPhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextStopPhase;
import org.mule.runtime.core.internal.lifecycle.phases.NotInLifecyclePhase;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.privileged.lifecycle.AbstractLifecycleManager;

public class RegistryLifecycleManager
extends AbstractLifecycleManager<Registry> {
    protected Map<String, LifecyclePhase> phases = new HashMap<String, LifecyclePhase>();
    protected SortedMap<String, LifecycleCallback> callbacks = new TreeMap<String, LifecycleCallback>();
    protected MuleContext muleContext;
    private final LifecycleInterceptor initDisposeLifecycleInterceptor = new PhaseErrorLifecycleInterceptor("initialise", "dispose", Initialisable.class);
    private final LifecycleInterceptor startstopLifecycleInterceptor = new PhaseErrorLifecycleInterceptor("start", "stop", Startable.class);

    public RegistryLifecycleManager(String id, Registry object, MuleContext muleContext) {
        super(id, object);
        this.muleContext = muleContext;
        this.registerPhases(object);
    }

    protected void registerPhases(Registry object) {
        RegistryLifecycleCallback callback = new RegistryLifecycleCallback(this);
        EmptyLifecycleCallback emptyCallback = new EmptyLifecycleCallback();
        this.registerPhase("not in lifecycle", new NotInLifecyclePhase(), emptyCallback);
        this.registerPhase("initialise", new MuleContextInitialisePhase(), callback);
        this.registerPhase("start", new MuleContextStartPhase(), emptyCallback);
        this.registerPhase("stop", new MuleContextStopPhase(), emptyCallback);
        this.registerPhase("dispose", new MuleContextDisposePhase(), callback);
    }

    public RegistryLifecycleManager(String id, Registry object, Map<String, LifecyclePhase> phases) {
        super(id, object);
        RegistryLifecycleCallback callback = new RegistryLifecycleCallback(this);
        this.registerPhase("not in lifecycle", new NotInLifecyclePhase(), new EmptyLifecycleCallback());
        for (Map.Entry<String, LifecyclePhase> entry : phases.entrySet()) {
            this.registerPhase(entry.getKey(), entry.getValue(), callback);
        }
    }

    @Override
    protected void registerTransitions() {
        this.addDirectTransition("not in lifecycle", "initialise");
        this.addDirectTransition("initialise", "start");
        this.addDirectTransition("start", "stop");
        this.addDirectTransition("stop", "start");
        this.addDirectTransition("not in lifecycle", "dispose");
        this.addDirectTransition("initialise", "dispose");
        this.addDirectTransition("stop", "dispose");
    }

    protected void registerPhase(String phaseName, LifecyclePhase phase) {
        this.registerPhase(phaseName, phase, new RegistryLifecycleCallback(this));
    }

    protected void registerPhase(String phaseName, LifecyclePhase phase, LifecycleCallback callback) {
        if (callback instanceof HasLifecycleInterceptor) {
            if ("initialise".equals(phaseName) || "dispose".equals(phaseName)) {
                ((HasLifecycleInterceptor)((Object)callback)).setLifecycleInterceptor(this.initDisposeLifecycleInterceptor);
            }
            if ("start".equals(phaseName) || "stop".equals(phaseName)) {
                ((HasLifecycleInterceptor)((Object)callback)).setLifecycleInterceptor(this.startstopLifecycleInterceptor);
            }
        }
        this.phaseNames.add(phaseName);
        this.callbacks.put(phaseName, callback);
        this.phases.put(phaseName, phase);
    }

    @Override
    public void fireLifecycle(String destinationPhase) throws LifecycleException {
        this.checkPhase(destinationPhase);
        if (this.isDirectTransition(destinationPhase) || this.isLastPhaseExecutionFailed()) {
            this.invokePhase(destinationPhase, this.object, (LifecycleCallback)this.callbacks.get(destinationPhase));
        } else {
            boolean start = false;
            for (String phase : this.phaseNames) {
                if (start) {
                    this.invokePhase(phase, this.object, (LifecycleCallback)this.callbacks.get(phase));
                    if (phase.equals(destinationPhase)) break;
                }
                if (!phase.equals(this.getCurrentPhase())) continue;
                start = true;
            }
        }
    }

    @Override
    protected void doOnConnectException(ConnectException ce) throws LifecycleException {
        throw new LifecycleException((Throwable)((Object)ce), (Object)this);
    }

    @Override
    public void applyPhase(Object object, String startPhase, String toPhase) throws LifecycleException {
        if (startPhase == null || toPhase == null) {
            throw new IllegalArgumentException("toPhase and fromPhase must be null");
        }
        if (!this.phaseNames.contains(startPhase)) {
            throw new IllegalArgumentException("fromPhase '" + startPhase + "' not a valid phase.");
        }
        if (!this.phaseNames.contains(toPhase)) {
            throw new IllegalArgumentException("toPhase '" + startPhase + "' not a valid phase.");
        }
        boolean started = false;
        for (String phaseName : this.phaseNames) {
            if (started) {
                this.phases.get(phaseName).applyLifecycle(object);
            }
            if (toPhase.equals(phaseName)) break;
            if (!phaseName.equals(startPhase)) continue;
            started = true;
        }
    }

    @Override
    public void applyCompletedPhases(Object object) throws LifecycleException {
        String lastPhase = "not in lifecycle";
        for (String phase : this.completedPhases) {
            if (!this.isDirectTransition(lastPhase, phase)) continue;
            LifecyclePhase lp = this.phases.get(phase);
            lp.applyLifecycle(object);
            lastPhase = phase;
        }
    }
}

